/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferNetwork;
import com.plaid.client.model.TransferType;
import com.plaid.client.model.TransferUserInRequestDeprecated;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/create`")
public class TransferCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_AUTHORIZATION_ID = "authorization_id";
    @SerializedName(value="authorization_id")
    private String authorizationId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferNetwork network;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInRequestDeprecated user;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;
    public static final String SERIALIZED_NAME_FACILITATOR_FEE = "facilitator_fee";
    @SerializedName(value="facilitator_fee")
    private String facilitatorFee;

    public TransferCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferCreateRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. `authorization_id` is now used as idempotency instead.  A random key provided by the client, per unique transfer. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create a transfer fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single transfer is created.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public TransferCreateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `access_token` for the account that will be debited or credited.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransferCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferCreateRequest authorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer authorization. This parameter also serves the purpose of acting as an idempotency identifier.")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public TransferCreateRequest type(TransferType type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public TransferCreateRequest network(TransferNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferNetwork network) {
        this.network = network;
    }

    public TransferCreateRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The transfer description. Maximum of 15 characters. If reprocessing a returned transfer, please note that the `description` field must be `\"Retry 1\"` or `\"Retry 2\"` to indicate that it's a retry of a previously returned transfer. You may retry a transfer up to 2 times, within 180 days of creating the original transfer. Only transfers that were returned with code `R01` or `R09` may be retried. For a full listing of ACH return codes, see [Transfer errors](https://plaid.com/docs/errors/transfer/#ach-return-codes).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferCreateRequest achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferCreateRequest user(TransferUserInRequestDeprecated user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferUserInRequestDeprecated getUser() {
        return this.user;
    }

    public void setUser(TransferUserInRequestDeprecated user) {
        this.user = user;
    }

    public TransferCreateRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public TransferCreateRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TransferCreateRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for the origination account for this transfer. If you have more than one origination account, this value must be specified. Otherwise, this field should be left blank.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferCreateRequest isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The currency of the transfer amount. The default value is \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferCreateRequest testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a test clock. This field may only be used when using `sandbox` environment. If provided, the `transfer` is created at the `virtual_time` on the provided `test_clock`.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public TransferCreateRequest facilitatorFee(String facilitatorFee) {
        this.facilitatorFee = facilitatorFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to deduct from `transfer.amount` and distribute to the platform\u2019s Ledger balance as a facilitator fee (decimal string with two digits of precision e.g. \"10.00\"). The remainder will go to the end-customer\u2019s Ledger balance. This must be less than or equal to the `transfer.amount`.")
    public String getFacilitatorFee() {
        return this.facilitatorFee;
    }

    public void setFacilitatorFee(String facilitatorFee) {
        this.facilitatorFee = facilitatorFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferCreateRequest transferCreateRequest = (TransferCreateRequest)o;
        return Objects.equals(this.clientId, transferCreateRequest.clientId) && Objects.equals(this.secret, transferCreateRequest.secret) && Objects.equals(this.idempotencyKey, transferCreateRequest.idempotencyKey) && Objects.equals(this.accessToken, transferCreateRequest.accessToken) && Objects.equals(this.accountId, transferCreateRequest.accountId) && Objects.equals(this.authorizationId, transferCreateRequest.authorizationId) && Objects.equals((Object)this.type, (Object)transferCreateRequest.type) && Objects.equals((Object)this.network, (Object)transferCreateRequest.network) && Objects.equals(this.amount, transferCreateRequest.amount) && Objects.equals(this.description, transferCreateRequest.description) && Objects.equals((Object)this.achClass, (Object)transferCreateRequest.achClass) && Objects.equals(this.user, transferCreateRequest.user) && Objects.equals(this.metadata, transferCreateRequest.metadata) && Objects.equals(this.originationAccountId, transferCreateRequest.originationAccountId) && Objects.equals(this.isoCurrencyCode, transferCreateRequest.isoCurrencyCode) && Objects.equals(this.testClockId, transferCreateRequest.testClockId) && Objects.equals(this.facilitatorFee, transferCreateRequest.facilitatorFee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.idempotencyKey, this.accessToken, this.accountId, this.authorizationId, this.type, this.network, this.amount, this.description, this.achClass, this.user, this.metadata, this.originationAccountId, this.isoCurrencyCode, this.testClockId, this.facilitatorFee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    authorizationId: ").append(this.toIndentedString(this.authorizationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("    facilitatorFee: ").append(this.toIndentedString(this.facilitatorFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

