/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.OriginatorExpectedTransferFrequency;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Specifies the originator's expected usage of debits. For all dollar amounts, use a decimal string with two digits of precision e.g. \"10.00\". This field is required if the originator is expected to process debit transfers.")
public class TransferDebitUsageConfiguration {
    public static final String SERIALIZED_NAME_EXPECTED_FREQUENCY = "expected_frequency";
    @SerializedName(value="expected_frequency")
    private OriginatorExpectedTransferFrequency expectedFrequency;
    public static final String SERIALIZED_NAME_EXPECTED_HIGHEST_AMOUNT = "expected_highest_amount";
    @SerializedName(value="expected_highest_amount")
    private String expectedHighestAmount;
    public static final String SERIALIZED_NAME_EXPECTED_AVERAGE_AMOUNT = "expected_average_amount";
    @SerializedName(value="expected_average_amount")
    private String expectedAverageAmount;
    public static final String SERIALIZED_NAME_EXPECTED_MONTHLY_AMOUNT = "expected_monthly_amount";
    @SerializedName(value="expected_monthly_amount")
    private String expectedMonthlyAmount;
    public static final String SERIALIZED_NAME_SEC_CODES = "sec_codes";
    @SerializedName(value="sec_codes")
    private List<ACHClass> secCodes = new ArrayList<ACHClass>();

    public TransferDebitUsageConfiguration expectedFrequency(OriginatorExpectedTransferFrequency expectedFrequency) {
        this.expectedFrequency = expectedFrequency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OriginatorExpectedTransferFrequency getExpectedFrequency() {
        return this.expectedFrequency;
    }

    public void setExpectedFrequency(OriginatorExpectedTransferFrequency expectedFrequency) {
        this.expectedFrequency = expectedFrequency;
    }

    public TransferDebitUsageConfiguration expectedHighestAmount(String expectedHighestAmount) {
        this.expectedHighestAmount = expectedHighestAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The originator\u2019s expected highest amount for a single debit transfer.")
    public String getExpectedHighestAmount() {
        return this.expectedHighestAmount;
    }

    public void setExpectedHighestAmount(String expectedHighestAmount) {
        this.expectedHighestAmount = expectedHighestAmount;
    }

    public TransferDebitUsageConfiguration expectedAverageAmount(String expectedAverageAmount) {
        this.expectedAverageAmount = expectedAverageAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The originator\u2019s expected average amount per debit.")
    public String getExpectedAverageAmount() {
        return this.expectedAverageAmount;
    }

    public void setExpectedAverageAmount(String expectedAverageAmount) {
        this.expectedAverageAmount = expectedAverageAmount;
    }

    public TransferDebitUsageConfiguration expectedMonthlyAmount(String expectedMonthlyAmount) {
        this.expectedMonthlyAmount = expectedMonthlyAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The originator\u2019s monthly expected ACH debit processing amount for the next 6-12 months.")
    public String getExpectedMonthlyAmount() {
        return this.expectedMonthlyAmount;
    }

    public void setExpectedMonthlyAmount(String expectedMonthlyAmount) {
        this.expectedMonthlyAmount = expectedMonthlyAmount;
    }

    public TransferDebitUsageConfiguration secCodes(List<ACHClass> secCodes) {
        this.secCodes = secCodes;
        return this;
    }

    public TransferDebitUsageConfiguration addSecCodesItem(ACHClass secCodesItem) {
        this.secCodes.add(secCodesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies the expected use cases for the originator\u2019s debit transfers. This should be a list that contains one or more of the following codes:  `\"ccd\"` - Corporate Credit or Debit - fund transfer between two corporate bank accounts  `\"ppd\"` - Prearranged Payment or Deposit - the transfer is part of a pre-existing relationship with a consumer, eg. bill payment  `\"tel\"` - Telephone-Initiated Entry  `\"web\"` - Internet-Initiated Entry - debits from a consumer\u2019s account where their authorization is obtained over the Internet")
    public List<ACHClass> getSecCodes() {
        return this.secCodes;
    }

    public void setSecCodes(List<ACHClass> secCodes) {
        this.secCodes = secCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferDebitUsageConfiguration transferDebitUsageConfiguration = (TransferDebitUsageConfiguration)o;
        return Objects.equals((Object)this.expectedFrequency, (Object)transferDebitUsageConfiguration.expectedFrequency) && Objects.equals(this.expectedHighestAmount, transferDebitUsageConfiguration.expectedHighestAmount) && Objects.equals(this.expectedAverageAmount, transferDebitUsageConfiguration.expectedAverageAmount) && Objects.equals(this.expectedMonthlyAmount, transferDebitUsageConfiguration.expectedMonthlyAmount) && Objects.equals(this.secCodes, transferDebitUsageConfiguration.secCodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.expectedFrequency, this.expectedHighestAmount, this.expectedAverageAmount, this.expectedMonthlyAmount, this.secCodes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferDebitUsageConfiguration {\n");
        sb.append("    expectedFrequency: ").append(this.toIndentedString((Object)this.expectedFrequency)).append("\n");
        sb.append("    expectedHighestAmount: ").append(this.toIndentedString(this.expectedHighestAmount)).append("\n");
        sb.append("    expectedAverageAmount: ").append(this.toIndentedString(this.expectedAverageAmount)).append("\n");
        sb.append("    expectedMonthlyAmount: ").append(this.toIndentedString(this.expectedMonthlyAmount)).append("\n");
        sb.append("    secCodes: ").append(this.toIndentedString(this.secCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

