/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about the device being used to initiate the authorization.")
public class TransferDevice {
    public static final String SERIALIZED_NAME_IP_ADDRESS = "ip_address";
    @SerializedName(value="ip_address")
    private String ipAddress;
    public static final String SERIALIZED_NAME_USER_AGENT = "user_agent";
    @SerializedName(value="user_agent")
    private String userAgent;

    public TransferDevice ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(required=true, value="The IP address of the device being used to initiate the authorization.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public TransferDevice userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @ApiModelProperty(required=true, value="The user agent of the device being used to initiate the authorization.")
    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferDevice transferDevice = (TransferDevice)o;
        return Objects.equals(this.ipAddress, transferDevice.ipAddress) && Objects.equals(this.userAgent, transferDevice.userAgent);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.userAgent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferDevice {\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    userAgent: ").append(this.toIndentedString(this.userAgent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

