/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.OmittableTransferType;
import com.plaid.client.model.TransferEventType;
import com.plaid.client.model.TransferFailure;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents an event in the Transfers API.")
public class TransferEvent {
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    private Integer eventId;
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    private OffsetDateTime timestamp;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "event_type";
    @SerializedName(value="event_type")
    private TransferEventType eventType;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_TRANSFER_TYPE = "transfer_type";
    @SerializedName(value="transfer_type")
    private OmittableTransferType transferType;
    public static final String SERIALIZED_NAME_TRANSFER_AMOUNT = "transfer_amount";
    @SerializedName(value="transfer_amount")
    private String transferAmount;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private TransferFailure failureReason;
    public static final String SERIALIZED_NAME_SWEEP_ID = "sweep_id";
    @SerializedName(value="sweep_id")
    private String sweepId;
    public static final String SERIALIZED_NAME_SWEEP_AMOUNT = "sweep_amount";
    @SerializedName(value="sweep_amount")
    private String sweepAmount;
    public static final String SERIALIZED_NAME_REFUND_ID = "refund_id";
    @SerializedName(value="refund_id")
    private String refundId;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;

    public TransferEvent eventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for this event. IDs are sequential unsigned 64-bit integers.")
    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public TransferEvent timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when this event occurred. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public TransferEvent eventType(TransferEventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(TransferEventType eventType) {
        this.eventType = eventType;
    }

    public TransferEvent accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account ID associated with the transfer. This field is omitted for Plaid Ledger Sweep events.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferEvent fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The id of the associated funding account, available in the Plaid Dashboard. If present, this indicates which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferEvent transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a transfer. This field is `null` for Plaid Ledger Sweep events.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransferEvent originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the origination account that this balance belongs to.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferEvent transferType(OmittableTransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OmittableTransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(OmittableTransferType transferType) {
        this.transferType = transferType;
    }

    public TransferEvent transferAmount(String transferAmount) {
        this.transferAmount = transferAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). This field is omitted for Plaid Ledger Sweep events.")
    public String getTransferAmount() {
        return this.transferAmount;
    }

    public void setTransferAmount(String transferAmount) {
        this.transferAmount = transferAmount;
    }

    public TransferEvent failureReason(TransferFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(TransferFailure failureReason) {
        this.failureReason = failureReason;
    }

    public TransferEvent sweepId(String sweepId) {
        this.sweepId = sweepId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a sweep.")
    public String getSweepId() {
        return this.sweepId;
    }

    public void setSweepId(String sweepId) {
        this.sweepId = sweepId;
    }

    public TransferEvent sweepAmount(String sweepAmount) {
        this.sweepAmount = sweepAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A signed amount of how much was `swept` or `return_swept` for this transfer (decimal string with two digits of precision e.g. \"-5.50\").")
    public String getSweepAmount() {
        return this.sweepAmount;
    }

    public void setSweepAmount(String sweepAmount) {
        this.sweepAmount = sweepAmount;
    }

    public TransferEvent refundId(String refundId) {
        this.refundId = refundId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a refund. A non-null value indicates the event is for the associated refund of the transfer.")
    public String getRefundId() {
        return this.refundId;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public TransferEvent originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The Plaid client ID that is the originator of the transfer that this event applies to. Only present if the transfer was created on behalf of another client as a third-party sender (TPS).")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEvent transferEvent = (TransferEvent)o;
        return Objects.equals(this.eventId, transferEvent.eventId) && Objects.equals(this.timestamp, transferEvent.timestamp) && Objects.equals((Object)this.eventType, (Object)transferEvent.eventType) && Objects.equals(this.accountId, transferEvent.accountId) && Objects.equals(this.fundingAccountId, transferEvent.fundingAccountId) && Objects.equals(this.transferId, transferEvent.transferId) && Objects.equals(this.originationAccountId, transferEvent.originationAccountId) && Objects.equals((Object)this.transferType, (Object)transferEvent.transferType) && Objects.equals(this.transferAmount, transferEvent.transferAmount) && Objects.equals(this.failureReason, transferEvent.failureReason) && Objects.equals(this.sweepId, transferEvent.sweepId) && Objects.equals(this.sweepAmount, transferEvent.sweepAmount) && Objects.equals(this.refundId, transferEvent.refundId) && Objects.equals(this.originatorClientId, transferEvent.originatorClientId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventId, this.timestamp, this.eventType, this.accountId, this.fundingAccountId, this.transferId, this.originationAccountId, this.transferType, this.transferAmount, this.failureReason, this.sweepId, this.sweepAmount, this.refundId, this.originatorClientId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    transferAmount: ").append(this.toIndentedString(this.transferAmount)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    sweepId: ").append(this.toIndentedString(this.sweepId)).append("\n");
        sb.append("    sweepAmount: ").append(this.toIndentedString(this.sweepAmount)).append("\n");
        sb.append("    refundId: ").append(this.toIndentedString(this.refundId)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

