/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferEventListTransferType;
import com.plaid.client.model.TransferEventType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/event/list`")
public class TransferEventListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private OffsetDateTime endDate;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_TRANSFER_TYPE = "transfer_type";
    @SerializedName(value="transfer_type")
    private TransferEventListTransferType transferType;
    public static final String SERIALIZED_NAME_EVENT_TYPES = "event_types";
    @SerializedName(value="event_types")
    private List<TransferEventType> eventTypes = null;
    public static final String SERIALIZED_NAME_SWEEP_ID = "sweep_id";
    @SerializedName(value="sweep_id")
    private String sweepId;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;

    public TransferEventListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferEventListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferEventListRequest startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start datetime of transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public TransferEventListRequest endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end datetime of transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public TransferEventListRequest transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a transfer.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransferEventListRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account ID to get events for all transactions to/from an account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferEventListRequest transferType(TransferEventListTransferType transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferEventListTransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferEventListTransferType transferType) {
        this.transferType = transferType;
    }

    public TransferEventListRequest eventTypes(List<TransferEventType> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public TransferEventListRequest addEventTypesItem(TransferEventType eventTypesItem) {
        if (this.eventTypes == null) {
            this.eventTypes = new ArrayList<TransferEventType>();
        }
        this.eventTypes.add(eventTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter events by event type.")
    public List<TransferEventType> getEventTypes() {
        return this.eventTypes;
    }

    public void setEventTypes(List<TransferEventType> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public TransferEventListRequest sweepId(String sweepId) {
        this.sweepId = sweepId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a sweep.")
    public String getSweepId() {
        return this.sweepId;
    }

    public void setSweepId(String sweepId) {
        this.sweepId = sweepId;
    }

    public TransferEventListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of transfer events to return. If the number of events matching the above parameters is greater than `count`, the most recent events will be returned.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public TransferEventListRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The offset into the list of transfer events. When `count`=25 and `offset`=0, the first 25 events will be returned. When `count`=25 and `offset`=25, the next 25 events will be returned.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public TransferEventListRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The origination account ID to get events for transfers from a specific origination account.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferEventListRequest originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter transfer events to only those with the specified originator client.")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferEventListRequest fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter transfer events to only those with the specified `funding_account_id`.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEventListRequest transferEventListRequest = (TransferEventListRequest)o;
        return Objects.equals(this.clientId, transferEventListRequest.clientId) && Objects.equals(this.secret, transferEventListRequest.secret) && Objects.equals(this.startDate, transferEventListRequest.startDate) && Objects.equals(this.endDate, transferEventListRequest.endDate) && Objects.equals(this.transferId, transferEventListRequest.transferId) && Objects.equals(this.accountId, transferEventListRequest.accountId) && Objects.equals((Object)this.transferType, (Object)transferEventListRequest.transferType) && Objects.equals(this.eventTypes, transferEventListRequest.eventTypes) && Objects.equals(this.sweepId, transferEventListRequest.sweepId) && Objects.equals(this.count, transferEventListRequest.count) && Objects.equals(this.offset, transferEventListRequest.offset) && Objects.equals(this.originationAccountId, transferEventListRequest.originationAccountId) && Objects.equals(this.originatorClientId, transferEventListRequest.originatorClientId) && Objects.equals(this.fundingAccountId, transferEventListRequest.fundingAccountId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.startDate, this.endDate, this.transferId, this.accountId, this.transferType, this.eventTypes, this.sweepId, this.count, this.offset, this.originationAccountId, this.originatorClientId, this.fundingAccountId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEventListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString((Object)this.transferType)).append("\n");
        sb.append("    eventTypes: ").append(this.toIndentedString(this.eventTypes)).append("\n");
        sb.append("    sweepId: ").append(this.toIndentedString(this.sweepId)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

