/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferEvent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines the response schema for `/transfer/event/sync`")
public class TransferEventSyncResponse {
    public static final String SERIALIZED_NAME_TRANSFER_EVENTS = "transfer_events";
    @SerializedName(value="transfer_events")
    private List<TransferEvent> transferEvents = new ArrayList<TransferEvent>();
    public static final String SERIALIZED_NAME_HAS_MORE = "has_more";
    @SerializedName(value="has_more")
    private Boolean hasMore;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public TransferEventSyncResponse transferEvents(List<TransferEvent> transferEvents) {
        this.transferEvents = transferEvents;
        return this;
    }

    public TransferEventSyncResponse addTransferEventsItem(TransferEvent transferEventsItem) {
        this.transferEvents.add(transferEventsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<TransferEvent> getTransferEvents() {
        return this.transferEvents;
    }

    public void setTransferEvents(List<TransferEvent> transferEvents) {
        this.transferEvents = transferEvents;
    }

    public TransferEventSyncResponse hasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @ApiModelProperty(required=true, value="Whether there are more events to be pulled from the endpoint that have not already been returned")
    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public TransferEventSyncResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEventSyncResponse transferEventSyncResponse = (TransferEventSyncResponse)o;
        return Objects.equals(this.transferEvents, transferEventSyncResponse.transferEvents) && Objects.equals(this.hasMore, transferEventSyncResponse.hasMore) && Objects.equals(this.requestId, transferEventSyncResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.transferEvents, this.hasMore, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEventSyncResponse {\n");
        sb.append("    transferEvents: ").append(this.toIndentedString(this.transferEvents)).append("\n");
        sb.append("    hasMore: ").append(this.toIndentedString(this.hasMore)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

