/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="Defines an expected sweep date and amount.")
public class TransferExpectedSweepSettlementScheduleItem {
    public static final String SERIALIZED_NAME_SWEEP_SETTLEMENT_DATE = "sweep_settlement_date";
    @SerializedName(value="sweep_settlement_date")
    private LocalDate sweepSettlementDate;
    public static final String SERIALIZED_NAME_SWEPT_SETTLED_AMOUNT = "swept_settled_amount";
    @SerializedName(value="swept_settled_amount")
    private String sweptSettledAmount;

    public TransferExpectedSweepSettlementScheduleItem sweepSettlementDate(LocalDate sweepSettlementDate) {
        this.sweepSettlementDate = sweepSettlementDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The settlement date of a sweep for this transfer.")
    public LocalDate getSweepSettlementDate() {
        return this.sweepSettlementDate;
    }

    public void setSweepSettlementDate(LocalDate sweepSettlementDate) {
        this.sweepSettlementDate = sweepSettlementDate;
    }

    public TransferExpectedSweepSettlementScheduleItem sweptSettledAmount(String sweptSettledAmount) {
        this.sweptSettledAmount = sweptSettledAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="The accumulated amount that has been swept by `sweep_settlement_date`.")
    public String getSweptSettledAmount() {
        return this.sweptSettledAmount;
    }

    public void setSweptSettledAmount(String sweptSettledAmount) {
        this.sweptSettledAmount = sweptSettledAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferExpectedSweepSettlementScheduleItem transferExpectedSweepSettlementScheduleItem = (TransferExpectedSweepSettlementScheduleItem)o;
        return Objects.equals(this.sweepSettlementDate, transferExpectedSweepSettlementScheduleItem.sweepSettlementDate) && Objects.equals(this.sweptSettledAmount, transferExpectedSweepSettlementScheduleItem.sweptSettledAmount);
    }

    public int hashCode() {
        return Objects.hash(this.sweepSettlementDate, this.sweptSettledAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferExpectedSweepSettlementScheduleItem {\n");
        sb.append("    sweepSettlementDate: ").append(this.toIndentedString(this.sweepSettlementDate)).append("\n");
        sb.append("    sweptSettledAmount: ").append(this.toIndentedString(this.sweptSettledAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

