/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferIntentCreateMode;
import com.plaid.client.model.TransferIntentCreateNetwork;
import com.plaid.client.model.TransferIntentStatus;
import com.plaid.client.model.TransferUserInResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a transfer intent within Transfer UI.")
public class TransferIntentCreate {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransferIntentStatus status;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private TransferIntentCreateMode mode;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferIntentCreateNetwork network = TransferIntentCreateNetwork.SAME_DAY_ACH;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInResponse user;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_REQUIRE_GUARANTEE = "require_guarantee";
    @SerializedName(value="require_guarantee")
    private Boolean requireGuarantee;

    public TransferIntentCreate id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for the transfer intent object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferIntentCreate created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime the transfer was created. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public TransferIntentCreate status(TransferIntentStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferIntentStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransferIntentStatus status) {
        this.status = status;
    }

    public TransferIntentCreate accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited. Returned only if `account_id` was set on intent creation.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferIntentCreate originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the origination account for the intent. If not provided, the default account will be used.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferIntentCreate fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the funding account to use, available in the Plaid Dashboard. This determines which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferIntentCreate amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferIntentCreate mode(TransferIntentCreateMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferIntentCreateMode getMode() {
        return this.mode;
    }

    public void setMode(TransferIntentCreateMode mode) {
        this.mode = mode;
    }

    public TransferIntentCreate network(TransferIntentCreateNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferIntentCreateNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferIntentCreateNetwork network) {
        this.network = network;
    }

    public TransferIntentCreate achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferIntentCreate user(TransferUserInResponse user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInResponse getUser() {
        return this.user;
    }

    public void setUser(TransferUserInResponse user) {
        this.user = user;
    }

    public TransferIntentCreate description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="A description for the underlying transfer. Maximum of 8 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferIntentCreate metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public TransferIntentCreate putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TransferIntentCreate isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount, e.g. \"USD\"")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferIntentCreate requireGuarantee(Boolean requireGuarantee) {
        this.requireGuarantee = requireGuarantee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, the transfer requires a `GUARANTEED` decision by Plaid to proceed (Guarantee customers only).")
    public Boolean getRequireGuarantee() {
        return this.requireGuarantee;
    }

    public void setRequireGuarantee(Boolean requireGuarantee) {
        this.requireGuarantee = requireGuarantee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferIntentCreate transferIntentCreate = (TransferIntentCreate)o;
        return Objects.equals(this.id, transferIntentCreate.id) && Objects.equals(this.created, transferIntentCreate.created) && Objects.equals((Object)this.status, (Object)transferIntentCreate.status) && Objects.equals(this.accountId, transferIntentCreate.accountId) && Objects.equals(this.originationAccountId, transferIntentCreate.originationAccountId) && Objects.equals(this.fundingAccountId, transferIntentCreate.fundingAccountId) && Objects.equals(this.amount, transferIntentCreate.amount) && Objects.equals((Object)this.mode, (Object)transferIntentCreate.mode) && Objects.equals((Object)this.network, (Object)transferIntentCreate.network) && Objects.equals((Object)this.achClass, (Object)transferIntentCreate.achClass) && Objects.equals(this.user, transferIntentCreate.user) && Objects.equals(this.description, transferIntentCreate.description) && Objects.equals(this.metadata, transferIntentCreate.metadata) && Objects.equals(this.isoCurrencyCode, transferIntentCreate.isoCurrencyCode) && Objects.equals(this.requireGuarantee, transferIntentCreate.requireGuarantee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.created, this.status, this.accountId, this.originationAccountId, this.fundingAccountId, this.amount, this.mode, this.network, this.achClass, this.user, this.description, this.metadata, this.isoCurrencyCode, this.requireGuarantee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferIntentCreate {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    requireGuarantee: ").append(this.toIndentedString(this.requireGuarantee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

