/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferIntentCreateMode;
import com.plaid.client.model.TransferIntentCreateNetwork;
import com.plaid.client.model.TransferUserInRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/intent/create`")
public class TransferIntentCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private TransferIntentCreateMode mode;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferIntentCreateNetwork network = TransferIntentCreateNetwork.SAME_DAY_ACH;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInRequest user;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_REQUIRE_GUARANTEE = "require_guarantee";
    @SerializedName(value="require_guarantee")
    private Boolean requireGuarantee = false;

    public TransferIntentCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferIntentCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferIntentCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferIntentCreateRequest fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify the account used to fund the transfer. Should be specified if using legacy funding methods only. If using Plaid Ledger, leave this field blank. Customers can find a list of `funding_account_id`s in the Accounts page of your Plaid Dashboard, under the \"Account ID\" column. If this field is left blank and you are using legacy funding methods, this will default to the default `funding_account_id` specified during onboarding. Otherwise, Plaid Ledger will be used.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferIntentCreateRequest mode(TransferIntentCreateMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferIntentCreateMode getMode() {
        return this.mode;
    }

    public void setMode(TransferIntentCreateMode mode) {
        this.mode = mode;
    }

    public TransferIntentCreateRequest network(TransferIntentCreateNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferIntentCreateNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferIntentCreateNetwork network) {
        this.network = network;
    }

    public TransferIntentCreateRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferIntentCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="A description for the underlying transfer. Maximum of 15 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferIntentCreateRequest achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferIntentCreateRequest originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for the origination account for the intent. If not provided, the default account will be used.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferIntentCreateRequest user(TransferUserInRequest user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInRequest getUser() {
        return this.user;
    }

    public void setUser(TransferUserInRequest user) {
        this.user = user;
    }

    public TransferIntentCreateRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public TransferIntentCreateRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TransferIntentCreateRequest isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The currency of the transfer amount, e.g. \"USD\"")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferIntentCreateRequest requireGuarantee(Boolean requireGuarantee) {
        this.requireGuarantee = requireGuarantee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, the transfer requires a `GUARANTEED` decision by Plaid to proceed (Guarantee customers only).")
    public Boolean getRequireGuarantee() {
        return this.requireGuarantee;
    }

    public void setRequireGuarantee(Boolean requireGuarantee) {
        this.requireGuarantee = requireGuarantee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferIntentCreateRequest transferIntentCreateRequest = (TransferIntentCreateRequest)o;
        return Objects.equals(this.clientId, transferIntentCreateRequest.clientId) && Objects.equals(this.secret, transferIntentCreateRequest.secret) && Objects.equals(this.accountId, transferIntentCreateRequest.accountId) && Objects.equals(this.fundingAccountId, transferIntentCreateRequest.fundingAccountId) && Objects.equals((Object)this.mode, (Object)transferIntentCreateRequest.mode) && Objects.equals((Object)this.network, (Object)transferIntentCreateRequest.network) && Objects.equals(this.amount, transferIntentCreateRequest.amount) && Objects.equals(this.description, transferIntentCreateRequest.description) && Objects.equals((Object)this.achClass, (Object)transferIntentCreateRequest.achClass) && Objects.equals(this.originationAccountId, transferIntentCreateRequest.originationAccountId) && Objects.equals(this.user, transferIntentCreateRequest.user) && Objects.equals(this.metadata, transferIntentCreateRequest.metadata) && Objects.equals(this.isoCurrencyCode, transferIntentCreateRequest.isoCurrencyCode) && Objects.equals(this.requireGuarantee, transferIntentCreateRequest.requireGuarantee);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accountId, this.fundingAccountId, this.mode, this.network, this.amount, this.description, this.achClass, this.originationAccountId, this.user, this.metadata, this.isoCurrencyCode, this.requireGuarantee});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferIntentCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    requireGuarantee: ").append(this.toIndentedString(this.requireGuarantee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

