/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferAuthorizationDecisionRationale;
import com.plaid.client.model.TransferAuthorizationGuaranteeDecision;
import com.plaid.client.model.TransferAuthorizationGuaranteeDecisionRationale;
import com.plaid.client.model.TransferIntentAuthorizationDecision;
import com.plaid.client.model.TransferIntentCreateMode;
import com.plaid.client.model.TransferIntentCreateNetwork;
import com.plaid.client.model.TransferIntentGetFailureReason;
import com.plaid.client.model.TransferIntentStatus;
import com.plaid.client.model.TransferUserInResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a transfer intent within Transfer UI.")
public class TransferIntentGet {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransferIntentStatus status;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private TransferIntentGetFailureReason failureReason;
    public static final String SERIALIZED_NAME_AUTHORIZATION_DECISION = "authorization_decision";
    @SerializedName(value="authorization_decision")
    private TransferIntentAuthorizationDecision authorizationDecision;
    public static final String SERIALIZED_NAME_AUTHORIZATION_DECISION_RATIONALE = "authorization_decision_rationale";
    @SerializedName(value="authorization_decision_rationale")
    private TransferAuthorizationDecisionRationale authorizationDecisionRationale;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_ORIGINATION_ACCOUNT_ID = "origination_account_id";
    @SerializedName(value="origination_account_id")
    private String originationAccountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_MODE = "mode";
    @SerializedName(value="mode")
    private TransferIntentCreateMode mode;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferIntentCreateNetwork network = TransferIntentCreateNetwork.SAME_DAY_ACH;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInResponse user;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_REQUIRE_GUARANTEE = "require_guarantee";
    @SerializedName(value="require_guarantee")
    private Boolean requireGuarantee;
    public static final String SERIALIZED_NAME_GUARANTEE_DECISION = "guarantee_decision";
    @SerializedName(value="guarantee_decision")
    private TransferAuthorizationGuaranteeDecision guaranteeDecision;
    public static final String SERIALIZED_NAME_GUARANTEE_DECISION_RATIONALE = "guarantee_decision_rationale";
    @SerializedName(value="guarantee_decision_rationale")
    private TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale;

    public TransferIntentGet id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for a transfer intent object.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferIntentGet created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime the transfer was created. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public TransferIntentGet status(TransferIntentStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferIntentStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransferIntentStatus status) {
        this.status = status;
    }

    public TransferIntentGet transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Plaid's unique identifier for the transfer created through the UI. Returned only if the transfer was successfully created. Null value otherwise.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransferIntentGet failureReason(TransferIntentGetFailureReason failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferIntentGetFailureReason getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(TransferIntentGetFailureReason failureReason) {
        this.failureReason = failureReason;
    }

    public TransferIntentGet authorizationDecision(TransferIntentAuthorizationDecision authorizationDecision) {
        this.authorizationDecision = authorizationDecision;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferIntentAuthorizationDecision getAuthorizationDecision() {
        return this.authorizationDecision;
    }

    public void setAuthorizationDecision(TransferIntentAuthorizationDecision authorizationDecision) {
        this.authorizationDecision = authorizationDecision;
    }

    public TransferIntentGet authorizationDecisionRationale(TransferAuthorizationDecisionRationale authorizationDecisionRationale) {
        this.authorizationDecisionRationale = authorizationDecisionRationale;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationDecisionRationale getAuthorizationDecisionRationale() {
        return this.authorizationDecisionRationale;
    }

    public void setAuthorizationDecisionRationale(TransferAuthorizationDecisionRationale authorizationDecisionRationale) {
        this.authorizationDecisionRationale = authorizationDecisionRationale;
    }

    public TransferIntentGet accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid `account_id` for the account that will be debited or credited. Returned only if `account_id` was set on intent creation.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferIntentGet originationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for the origination account used for the transfer.")
    public String getOriginationAccountId() {
        return this.originationAccountId;
    }

    public void setOriginationAccountId(String originationAccountId) {
        this.originationAccountId = originationAccountId;
    }

    public TransferIntentGet fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the funding account to use, available in the Plaid Dashboard. This determines which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferIntentGet amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferIntentGet mode(TransferIntentCreateMode mode) {
        this.mode = mode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferIntentCreateMode getMode() {
        return this.mode;
    }

    public void setMode(TransferIntentCreateMode mode) {
        this.mode = mode;
    }

    public TransferIntentGet network(TransferIntentCreateNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferIntentCreateNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferIntentCreateNetwork network) {
        this.network = network;
    }

    public TransferIntentGet achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferIntentGet user(TransferUserInResponse user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInResponse getUser() {
        return this.user;
    }

    public void setUser(TransferUserInResponse user) {
        this.user = user;
    }

    public TransferIntentGet description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="A description for the underlying transfer. Maximum of 8 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferIntentGet metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public TransferIntentGet putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Metadata object is a mapping of client-provided string fields to any string value. The following limitations apply: The JSON values must be Strings (no nested JSON objects allowed) Only ASCII characters may be used Maximum of 50 key/value pairs Maximum key length of 40 characters Maximum value length of 500 characters ")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public TransferIntentGet isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the transfer amount, e.g. \"USD\"")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferIntentGet requireGuarantee(Boolean requireGuarantee) {
        this.requireGuarantee = requireGuarantee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, the transfer requires a `GUARANTEED` decision by Plaid to proceed (Guarantee customers only).")
    public Boolean getRequireGuarantee() {
        return this.requireGuarantee;
    }

    public void setRequireGuarantee(Boolean requireGuarantee) {
        this.requireGuarantee = requireGuarantee;
    }

    public TransferIntentGet guaranteeDecision(TransferAuthorizationGuaranteeDecision guaranteeDecision) {
        this.guaranteeDecision = guaranteeDecision;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationGuaranteeDecision getGuaranteeDecision() {
        return this.guaranteeDecision;
    }

    public void setGuaranteeDecision(TransferAuthorizationGuaranteeDecision guaranteeDecision) {
        this.guaranteeDecision = guaranteeDecision;
    }

    public TransferIntentGet guaranteeDecisionRationale(TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale) {
        this.guaranteeDecisionRationale = guaranteeDecisionRationale;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferAuthorizationGuaranteeDecisionRationale getGuaranteeDecisionRationale() {
        return this.guaranteeDecisionRationale;
    }

    public void setGuaranteeDecisionRationale(TransferAuthorizationGuaranteeDecisionRationale guaranteeDecisionRationale) {
        this.guaranteeDecisionRationale = guaranteeDecisionRationale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferIntentGet transferIntentGet = (TransferIntentGet)o;
        return Objects.equals(this.id, transferIntentGet.id) && Objects.equals(this.created, transferIntentGet.created) && Objects.equals((Object)this.status, (Object)transferIntentGet.status) && Objects.equals(this.transferId, transferIntentGet.transferId) && Objects.equals(this.failureReason, transferIntentGet.failureReason) && Objects.equals((Object)this.authorizationDecision, (Object)transferIntentGet.authorizationDecision) && Objects.equals(this.authorizationDecisionRationale, transferIntentGet.authorizationDecisionRationale) && Objects.equals(this.accountId, transferIntentGet.accountId) && Objects.equals(this.originationAccountId, transferIntentGet.originationAccountId) && Objects.equals(this.fundingAccountId, transferIntentGet.fundingAccountId) && Objects.equals(this.amount, transferIntentGet.amount) && Objects.equals((Object)this.mode, (Object)transferIntentGet.mode) && Objects.equals((Object)this.network, (Object)transferIntentGet.network) && Objects.equals((Object)this.achClass, (Object)transferIntentGet.achClass) && Objects.equals(this.user, transferIntentGet.user) && Objects.equals(this.description, transferIntentGet.description) && Objects.equals(this.metadata, transferIntentGet.metadata) && Objects.equals(this.isoCurrencyCode, transferIntentGet.isoCurrencyCode) && Objects.equals(this.requireGuarantee, transferIntentGet.requireGuarantee) && Objects.equals((Object)this.guaranteeDecision, (Object)transferIntentGet.guaranteeDecision) && Objects.equals(this.guaranteeDecisionRationale, transferIntentGet.guaranteeDecisionRationale);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.created, this.status, this.transferId, this.failureReason, this.authorizationDecision, this.authorizationDecisionRationale, this.accountId, this.originationAccountId, this.fundingAccountId, this.amount, this.mode, this.network, this.achClass, this.user, this.description, this.metadata, this.isoCurrencyCode, this.requireGuarantee, this.guaranteeDecision, this.guaranteeDecisionRationale});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferIntentGet {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    authorizationDecision: ").append(this.toIndentedString((Object)this.authorizationDecision)).append("\n");
        sb.append("    authorizationDecisionRationale: ").append(this.toIndentedString(this.authorizationDecisionRationale)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    originationAccountId: ").append(this.toIndentedString(this.originationAccountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    requireGuarantee: ").append(this.toIndentedString(this.requireGuarantee)).append("\n");
        sb.append("    guaranteeDecision: ").append(this.toIndentedString((Object)this.guaranteeDecision)).append("\n");
        sb.append("    guaranteeDecisionRationale: ").append(this.toIndentedString(this.guaranteeDecisionRationale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

