/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The reason for a failed transfer intent. Returned only if the transfer intent status is `failed`. Null otherwise.")
public class TransferIntentGetFailureReason {
    public static final String SERIALIZED_NAME_ERROR_TYPE = "error_type";
    @SerializedName(value="error_type")
    private String errorType;
    public static final String SERIALIZED_NAME_ERROR_CODE = "error_code";
    @SerializedName(value="error_code")
    private String errorCode;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "error_message";
    @SerializedName(value="error_message")
    private String errorMessage;

    public TransferIntentGetFailureReason errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A broad categorization of the error.")
    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public TransferIntentGetFailureReason errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A code representing the reason for a failed transfer intent (i.e., an API error or the authorization being declined).")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public TransferIntentGetFailureReason errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable description of the code associated with a failed transfer intent.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferIntentGetFailureReason transferIntentGetFailureReason = (TransferIntentGetFailureReason)o;
        return Objects.equals(this.errorType, transferIntentGetFailureReason.errorType) && Objects.equals(this.errorCode, transferIntentGetFailureReason.errorCode) && Objects.equals(this.errorMessage, transferIntentGetFailureReason.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.errorType, this.errorCode, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferIntentGetFailureReason {\n");
        sb.append("    errorType: ").append(this.toIndentedString(this.errorType)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

