/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/intent/get`")
public class TransferIntentGetRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TRANSFER_INTENT_ID = "transfer_intent_id";
    @SerializedName(value="transfer_intent_id")
    private String transferIntentId;

    public TransferIntentGetRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferIntentGetRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferIntentGetRequest transferIntentId(String transferIntentId) {
        this.transferIntentId = transferIntentId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for a transfer intent object.")
    public String getTransferIntentId() {
        return this.transferIntentId;
    }

    public void setTransferIntentId(String transferIntentId) {
        this.transferIntentId = transferIntentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferIntentGetRequest transferIntentGetRequest = (TransferIntentGetRequest)o;
        return Objects.equals(this.clientId, transferIntentGetRequest.clientId) && Objects.equals(this.secret, transferIntentGetRequest.secret) && Objects.equals(this.transferIntentId, transferIntentGetRequest.transferIntentId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.transferIntentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferIntentGetRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    transferIntentId: ").append(this.toIndentedString(this.transferIntentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

