/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Information about the balance of the ledger held with Plaid.")
public class TransferLedgerBalance {
    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(value="available")
    private String available;
    public static final String SERIALIZED_NAME_PENDING = "pending";
    @SerializedName(value="pending")
    private String pending;

    public TransferLedgerBalance available(String available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of this balance available for use (decimal string with two digits of precision e.g. \"10.00\").")
    public String getAvailable() {
        return this.available;
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    public TransferLedgerBalance pending(String pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of pending funds that are in processing (decimal string with two digits of precision e.g. \"10.00\").")
    public String getPending() {
        return this.pending;
    }

    public void setPending(String pending) {
        this.pending = pending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferLedgerBalance transferLedgerBalance = (TransferLedgerBalance)o;
        return Objects.equals(this.available, transferLedgerBalance.available) && Objects.equals(this.pending, transferLedgerBalance.pending);
    }

    public int hashCode() {
        return Objects.hash(this.available, this.pending);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferLedgerBalance {\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

