/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/ledger/distribute`")
public class TransferLedgerDistributeRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_FROM_CLIENT_ID = "from_client_id";
    @SerializedName(value="from_client_id")
    private String fromClientId;
    public static final String SERIALIZED_NAME_TO_CLIENT_ID = "to_client_id";
    @SerializedName(value="to_client_id")
    private String toClientId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;

    public TransferLedgerDistributeRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferLedgerDistributeRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferLedgerDistributeRequest fromClientId(String fromClientId) {
        this.fromClientId = fromClientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The client to pull money from. Must be the platform itself or its originator. One of `from_client_id` and `to_client_id` must be the platform's `client_id`.")
    public String getFromClientId() {
        return this.fromClientId;
    }

    public void setFromClientId(String fromClientId) {
        this.fromClientId = fromClientId;
    }

    public TransferLedgerDistributeRequest toClientId(String toClientId) {
        this.toClientId = toClientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The client to credit money to. Must be the platform itself or its originator. One of `from_client_id` and `to_client_id` must be the platform's `client_id`.")
    public String getToClientId() {
        return this.toClientId;
    }

    public void setToClientId(String toClientId) {
        this.toClientId = toClientId;
    }

    public TransferLedgerDistributeRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount to move (decimal string with two digits of precision e.g. \"10.00\"). Amount must be positive.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferLedgerDistributeRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique key provided by the client, per unique ledger distribute. Maximum of 50 characters.  The API supports idempotency for safely retrying the request without accidentally performing the same operation twice. For example, if a request to create a ledger distribute fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single distribute is created.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public TransferLedgerDistributeRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional description for the ledger distribute operation.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferLedgerDistributeRequest transferLedgerDistributeRequest = (TransferLedgerDistributeRequest)o;
        return Objects.equals(this.clientId, transferLedgerDistributeRequest.clientId) && Objects.equals(this.secret, transferLedgerDistributeRequest.secret) && Objects.equals(this.fromClientId, transferLedgerDistributeRequest.fromClientId) && Objects.equals(this.toClientId, transferLedgerDistributeRequest.toClientId) && Objects.equals(this.amount, transferLedgerDistributeRequest.amount) && Objects.equals(this.idempotencyKey, transferLedgerDistributeRequest.idempotencyKey) && Objects.equals(this.description, transferLedgerDistributeRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.fromClientId, this.toClientId, this.amount, this.idempotencyKey, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferLedgerDistributeRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    fromClientId: ").append(this.toIndentedString(this.fromClientId)).append("\n");
        sb.append("    toClientId: ").append(this.toIndentedString(this.toClientId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

