/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferMetricsGetReturnRates;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the response schema for `/transfer/metrics/get`")
public class TransferMetricsGetResponse {
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;
    public static final String SERIALIZED_NAME_DAILY_DEBIT_TRANSFER_VOLUME = "daily_debit_transfer_volume";
    @SerializedName(value="daily_debit_transfer_volume")
    private String dailyDebitTransferVolume;
    public static final String SERIALIZED_NAME_DAILY_CREDIT_TRANSFER_VOLUME = "daily_credit_transfer_volume";
    @SerializedName(value="daily_credit_transfer_volume")
    private String dailyCreditTransferVolume;
    public static final String SERIALIZED_NAME_MONTHLY_TRANSFER_VOLUME = "monthly_transfer_volume";
    @SerializedName(value="monthly_transfer_volume")
    private String monthlyTransferVolume;
    public static final String SERIALIZED_NAME_MONTHLY_DEBIT_TRANSFER_VOLUME = "monthly_debit_transfer_volume";
    @SerializedName(value="monthly_debit_transfer_volume")
    private String monthlyDebitTransferVolume;
    public static final String SERIALIZED_NAME_MONTHLY_CREDIT_TRANSFER_VOLUME = "monthly_credit_transfer_volume";
    @SerializedName(value="monthly_credit_transfer_volume")
    private String monthlyCreditTransferVolume;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_RETURN_RATES = "return_rates";
    @SerializedName(value="return_rates")
    private TransferMetricsGetReturnRates returnRates;

    public TransferMetricsGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public TransferMetricsGetResponse dailyDebitTransferVolume(String dailyDebitTransferVolume) {
        this.dailyDebitTransferVolume = dailyDebitTransferVolume;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of dollar amount of debit transfers in last 24 hours (decimal string with two digits of precision e.g. \"10.00\").")
    public String getDailyDebitTransferVolume() {
        return this.dailyDebitTransferVolume;
    }

    public void setDailyDebitTransferVolume(String dailyDebitTransferVolume) {
        this.dailyDebitTransferVolume = dailyDebitTransferVolume;
    }

    public TransferMetricsGetResponse dailyCreditTransferVolume(String dailyCreditTransferVolume) {
        this.dailyCreditTransferVolume = dailyCreditTransferVolume;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of dollar amount of credit transfers in last 24 hours (decimal string with two digits of precision e.g. \"10.00\").")
    public String getDailyCreditTransferVolume() {
        return this.dailyCreditTransferVolume;
    }

    public void setDailyCreditTransferVolume(String dailyCreditTransferVolume) {
        this.dailyCreditTransferVolume = dailyCreditTransferVolume;
    }

    public TransferMetricsGetResponse monthlyTransferVolume(String monthlyTransferVolume) {
        this.monthlyTransferVolume = monthlyTransferVolume;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of dollar amount of credit and debit transfers in current calendar month (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMonthlyTransferVolume() {
        return this.monthlyTransferVolume;
    }

    public void setMonthlyTransferVolume(String monthlyTransferVolume) {
        this.monthlyTransferVolume = monthlyTransferVolume;
    }

    public TransferMetricsGetResponse monthlyDebitTransferVolume(String monthlyDebitTransferVolume) {
        this.monthlyDebitTransferVolume = monthlyDebitTransferVolume;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of dollar amount of debit transfers in current calendar month (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMonthlyDebitTransferVolume() {
        return this.monthlyDebitTransferVolume;
    }

    public void setMonthlyDebitTransferVolume(String monthlyDebitTransferVolume) {
        this.monthlyDebitTransferVolume = monthlyDebitTransferVolume;
    }

    public TransferMetricsGetResponse monthlyCreditTransferVolume(String monthlyCreditTransferVolume) {
        this.monthlyCreditTransferVolume = monthlyCreditTransferVolume;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of dollar amount of credit transfers in current calendar month (decimal string with two digits of precision e.g. \"10.00\").")
    public String getMonthlyCreditTransferVolume() {
        return this.monthlyCreditTransferVolume;
    }

    public void setMonthlyCreditTransferVolume(String monthlyCreditTransferVolume) {
        this.monthlyCreditTransferVolume = monthlyCreditTransferVolume;
    }

    public TransferMetricsGetResponse isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the dollar amount, e.g. \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferMetricsGetResponse returnRates(TransferMetricsGetReturnRates returnRates) {
        this.returnRates = returnRates;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferMetricsGetReturnRates getReturnRates() {
        return this.returnRates;
    }

    public void setReturnRates(TransferMetricsGetReturnRates returnRates) {
        this.returnRates = returnRates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferMetricsGetResponse transferMetricsGetResponse = (TransferMetricsGetResponse)o;
        return Objects.equals(this.requestId, transferMetricsGetResponse.requestId) && Objects.equals(this.dailyDebitTransferVolume, transferMetricsGetResponse.dailyDebitTransferVolume) && Objects.equals(this.dailyCreditTransferVolume, transferMetricsGetResponse.dailyCreditTransferVolume) && Objects.equals(this.monthlyTransferVolume, transferMetricsGetResponse.monthlyTransferVolume) && Objects.equals(this.monthlyDebitTransferVolume, transferMetricsGetResponse.monthlyDebitTransferVolume) && Objects.equals(this.monthlyCreditTransferVolume, transferMetricsGetResponse.monthlyCreditTransferVolume) && Objects.equals(this.isoCurrencyCode, transferMetricsGetResponse.isoCurrencyCode) && Objects.equals(this.returnRates, transferMetricsGetResponse.returnRates);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.dailyDebitTransferVolume, this.dailyCreditTransferVolume, this.monthlyTransferVolume, this.monthlyDebitTransferVolume, this.monthlyCreditTransferVolume, this.isoCurrencyCode, this.returnRates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferMetricsGetResponse {\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    dailyDebitTransferVolume: ").append(this.toIndentedString(this.dailyDebitTransferVolume)).append("\n");
        sb.append("    dailyCreditTransferVolume: ").append(this.toIndentedString(this.dailyCreditTransferVolume)).append("\n");
        sb.append("    monthlyTransferVolume: ").append(this.toIndentedString(this.monthlyTransferVolume)).append("\n");
        sb.append("    monthlyDebitTransferVolume: ").append(this.toIndentedString(this.monthlyDebitTransferVolume)).append("\n");
        sb.append("    monthlyCreditTransferVolume: ").append(this.toIndentedString(this.monthlyCreditTransferVolume)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    returnRates: ").append(this.toIndentedString(this.returnRates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

