/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The originator's address.")
public class TransferOriginatorAddress {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private String countryCode;

    public TransferOriginatorAddress city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(required=true, value="The full city name.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public TransferOriginatorAddress street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(required=true, value="The full street address.")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public TransferOriginatorAddress region(String region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(required=true, value="The two-letter code for the state or province (e.g., \"CA\").")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public TransferOriginatorAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The postal code (e.g., \"94103\").")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public TransferOriginatorAddress countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(required=true, value="ISO-3166-1 alpha-2 country code standard.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOriginatorAddress transferOriginatorAddress = (TransferOriginatorAddress)o;
        return Objects.equals(this.city, transferOriginatorAddress.city) && Objects.equals(this.street, transferOriginatorAddress.street) && Objects.equals(this.region, transferOriginatorAddress.region) && Objects.equals(this.postalCode, transferOriginatorAddress.postalCode) && Objects.equals(this.countryCode, transferOriginatorAddress.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.street, this.region, this.postalCode, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOriginatorAddress {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

