/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Defines the response schema for `/transfer/originator/create`")
public class TransferOriginatorCreateResponse {
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_COMPANY_NAME = "company_name";
    @SerializedName(value="company_name")
    private String companyName;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public TransferOriginatorCreateResponse originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @ApiModelProperty(required=true, value="Client ID of the originator. This identifier will be used when creating transfers and should be stored associated with end user information.")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferOriginatorCreateResponse companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(required=true, value="The company name of the end customer.")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public TransferOriginatorCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOriginatorCreateResponse transferOriginatorCreateResponse = (TransferOriginatorCreateResponse)o;
        return Objects.equals(this.originatorClientId, transferOriginatorCreateResponse.originatorClientId) && Objects.equals(this.companyName, transferOriginatorCreateResponse.companyName) && Objects.equals(this.requestId, transferOriginatorCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.originatorClientId, this.companyName, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOriginatorCreateResponse {\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

