/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferCreditUsageConfiguration;
import com.plaid.client.model.TransferDebitUsageConfiguration;
import com.plaid.client.model.TransferFundingAccount;
import com.plaid.client.model.TransferOriginatorAddress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The diligence information for the originator.")
public class TransferOriginatorDiligence {
    public static final String SERIALIZED_NAME_DBA = "dba";
    @SerializedName(value="dba")
    private String dba;
    public static final String SERIALIZED_NAME_TAX_ID = "tax_id";
    @SerializedName(value="tax_id")
    private String taxId;
    public static final String SERIALIZED_NAME_CREDIT_USAGE_CONFIGURATION = "credit_usage_configuration";
    @SerializedName(value="credit_usage_configuration")
    private TransferCreditUsageConfiguration creditUsageConfiguration;
    public static final String SERIALIZED_NAME_DEBIT_USAGE_CONFIGURATION = "debit_usage_configuration";
    @SerializedName(value="debit_usage_configuration")
    private TransferDebitUsageConfiguration debitUsageConfiguration;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private TransferOriginatorAddress address;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;
    public static final String SERIALIZED_NAME_NAICS_CODE = "naics_code";
    @SerializedName(value="naics_code")
    private String naicsCode;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT = "funding_account";
    @SerializedName(value="funding_account")
    private TransferFundingAccount fundingAccount;

    public TransferOriginatorDiligence dba(String dba) {
        this.dba = dba;
        return this;
    }

    @ApiModelProperty(required=true, value="The business name of the originator.")
    public String getDba() {
        return this.dba;
    }

    public void setDba(String dba) {
        this.dba = dba;
    }

    public TransferOriginatorDiligence taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(required=true, value="The tax ID of the originator.")
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public TransferOriginatorDiligence creditUsageConfiguration(TransferCreditUsageConfiguration creditUsageConfiguration) {
        this.creditUsageConfiguration = creditUsageConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferCreditUsageConfiguration getCreditUsageConfiguration() {
        return this.creditUsageConfiguration;
    }

    public void setCreditUsageConfiguration(TransferCreditUsageConfiguration creditUsageConfiguration) {
        this.creditUsageConfiguration = creditUsageConfiguration;
    }

    public TransferOriginatorDiligence debitUsageConfiguration(TransferDebitUsageConfiguration debitUsageConfiguration) {
        this.debitUsageConfiguration = debitUsageConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferDebitUsageConfiguration getDebitUsageConfiguration() {
        return this.debitUsageConfiguration;
    }

    public void setDebitUsageConfiguration(TransferDebitUsageConfiguration debitUsageConfiguration) {
        this.debitUsageConfiguration = debitUsageConfiguration;
    }

    public TransferOriginatorDiligence address(TransferOriginatorAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferOriginatorAddress getAddress() {
        return this.address;
    }

    public void setAddress(TransferOriginatorAddress address) {
        this.address = address;
    }

    public TransferOriginatorDiligence website(String website) {
        this.website = website;
        return this;
    }

    @ApiModelProperty(required=true, value="The website of the originator.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public TransferOriginatorDiligence naicsCode(String naicsCode) {
        this.naicsCode = naicsCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The NAICS code of the originator.")
    public String getNaicsCode() {
        return this.naicsCode;
    }

    public void setNaicsCode(String naicsCode) {
        this.naicsCode = naicsCode;
    }

    public TransferOriginatorDiligence fundingAccount(TransferFundingAccount fundingAccount) {
        this.fundingAccount = fundingAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferFundingAccount getFundingAccount() {
        return this.fundingAccount;
    }

    public void setFundingAccount(TransferFundingAccount fundingAccount) {
        this.fundingAccount = fundingAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOriginatorDiligence transferOriginatorDiligence = (TransferOriginatorDiligence)o;
        return Objects.equals(this.dba, transferOriginatorDiligence.dba) && Objects.equals(this.taxId, transferOriginatorDiligence.taxId) && Objects.equals(this.creditUsageConfiguration, transferOriginatorDiligence.creditUsageConfiguration) && Objects.equals(this.debitUsageConfiguration, transferOriginatorDiligence.debitUsageConfiguration) && Objects.equals(this.address, transferOriginatorDiligence.address) && Objects.equals(this.website, transferOriginatorDiligence.website) && Objects.equals(this.naicsCode, transferOriginatorDiligence.naicsCode) && Objects.equals(this.fundingAccount, transferOriginatorDiligence.fundingAccount);
    }

    public int hashCode() {
        return Objects.hash(this.dba, this.taxId, this.creditUsageConfiguration, this.debitUsageConfiguration, this.address, this.website, this.naicsCode, this.fundingAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOriginatorDiligence {\n");
        sb.append("    dba: ").append(this.toIndentedString(this.dba)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("    creditUsageConfiguration: ").append(this.toIndentedString(this.creditUsageConfiguration)).append("\n");
        sb.append("    debitUsageConfiguration: ").append(this.toIndentedString(this.debitUsageConfiguration)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    naicsCode: ").append(this.toIndentedString(this.naicsCode)).append("\n");
        sb.append("    fundingAccount: ").append(this.toIndentedString(this.fundingAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

