/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferFundingAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/originator/funding_account/update`")
public class TransferOriginatorFundingAccountUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT = "funding_account";
    @SerializedName(value="funding_account")
    private TransferFundingAccount fundingAccount;

    public TransferOriginatorFundingAccountUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferOriginatorFundingAccountUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferOriginatorFundingAccountUpdateRequest originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid client ID of the transfer originator.")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferOriginatorFundingAccountUpdateRequest fundingAccount(TransferFundingAccount fundingAccount) {
        this.fundingAccount = fundingAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferFundingAccount getFundingAccount() {
        return this.fundingAccount;
    }

    public void setFundingAccount(TransferFundingAccount fundingAccount) {
        this.fundingAccount = fundingAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferOriginatorFundingAccountUpdateRequest transferOriginatorFundingAccountUpdateRequest = (TransferOriginatorFundingAccountUpdateRequest)o;
        return Objects.equals(this.clientId, transferOriginatorFundingAccountUpdateRequest.clientId) && Objects.equals(this.secret, transferOriginatorFundingAccountUpdateRequest.secret) && Objects.equals(this.originatorClientId, transferOriginatorFundingAccountUpdateRequest.originatorClientId) && Objects.equals(this.fundingAccount, transferOriginatorFundingAccountUpdateRequest.fundingAccount);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.originatorClientId, this.fundingAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferOriginatorFundingAccountUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    fundingAccount: ").append(this.toIndentedString(this.fundingAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

