/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/recurring/cancel`")
public class TransferRecurringCancelRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RECURRING_TRANSFER_ID = "recurring_transfer_id";
    @SerializedName(value="recurring_transfer_id")
    private String recurringTransferId;

    public TransferRecurringCancelRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferRecurringCancelRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferRecurringCancelRequest recurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a recurring transfer.")
    public String getRecurringTransferId() {
        return this.recurringTransferId;
    }

    public void setRecurringTransferId(String recurringTransferId) {
        this.recurringTransferId = recurringTransferId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRecurringCancelRequest transferRecurringCancelRequest = (TransferRecurringCancelRequest)o;
        return Objects.equals(this.clientId, transferRecurringCancelRequest.clientId) && Objects.equals(this.secret, transferRecurringCancelRequest.secret) && Objects.equals(this.recurringTransferId, transferRecurringCancelRequest.recurringTransferId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.recurringTransferId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRecurringCancelRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    recurringTransferId: ").append(this.toIndentedString(this.recurringTransferId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

