/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ACHClass;
import com.plaid.client.model.TransferDevice;
import com.plaid.client.model.TransferRecurringNetwork;
import com.plaid.client.model.TransferRecurringSchedule;
import com.plaid.client.model.TransferType;
import com.plaid.client.model.TransferUserInRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/recurring/create`")
public class TransferRecurringCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ACCESS_TOKEN = "access_token";
    @SerializedName(value="access_token")
    private String accessToken;
    public static final String SERIALIZED_NAME_IDEMPOTENCY_KEY = "idempotency_key";
    @SerializedName(value="idempotency_key")
    private String idempotencyKey;
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TransferType type;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private TransferRecurringNetwork network;
    public static final String SERIALIZED_NAME_ACH_CLASS = "ach_class";
    @SerializedName(value="ach_class")
    private ACHClass achClass;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_USER_PRESENT = "user_present";
    @SerializedName(value="user_present")
    private Boolean userPresent;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;
    public static final String SERIALIZED_NAME_SCHEDULE = "schedule";
    @SerializedName(value="schedule")
    private TransferRecurringSchedule schedule;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private TransferUserInRequest user;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    private TransferDevice device;

    public TransferRecurringCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferRecurringCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferRecurringCreateRequest accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `access_token` for the account that will be debited or credited.")
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TransferRecurringCreateRequest idempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="A random key provided by the client, per unique recurring transfer. Maximum of 50 characters.  The API supports idempotency for safely retrying requests without accidentally performing the same operation twice. For example, if a request to create a recurring fails due to a network connection error, you can retry the request with the same idempotency key to guarantee that only a single recurring transfer is created.")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public void setIdempotencyKey(String idempotencyKey) {
        this.idempotencyKey = idempotencyKey;
    }

    public TransferRecurringCreateRequest accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` corresponding to the end-user account that will be debited or credited.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public TransferRecurringCreateRequest fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify the account used to fund the transfer. Customers can find a list of `funding_account_id`s in the Accounts page of your Plaid Dashboard, under the \"Account ID\" column. If this field is left blank, it will default to the default `funding_account_id` specified during onboarding.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferRecurringCreateRequest type(TransferType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferType getType() {
        return this.type;
    }

    public void setType(TransferType type) {
        this.type = type;
    }

    public TransferRecurringCreateRequest network(TransferRecurringNetwork network) {
        this.network = network;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferRecurringNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(TransferRecurringNetwork network) {
        this.network = network;
    }

    public TransferRecurringCreateRequest achClass(ACHClass achClass) {
        this.achClass = achClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ACHClass getAchClass() {
        return this.achClass;
    }

    public void setAchClass(ACHClass achClass) {
        this.achClass = achClass;
    }

    public TransferRecurringCreateRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the transfer (decimal string with two digits of precision e.g. \"10.00\"). When calling `/transfer/authorization/create`, specify the maximum amount to authorize. When calling `/transfer/create`, specify the exact amount of the transfer, up to a maximum of the amount authorized. If this field is left blank when calling `/transfer/create`, the maximum amount authorized in the `authorization_id` will be sent.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferRecurringCreateRequest userPresent(Boolean userPresent) {
        this.userPresent = userPresent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the end user is initiating the specific transfer themselves via an interactive UI, this should be `true`; for automatic recurring payments where the end user is not actually initiating each individual transfer, it should be `false`.")
    public Boolean getUserPresent() {
        return this.userPresent;
    }

    public void setUserPresent(Boolean userPresent) {
        this.userPresent = userPresent;
    }

    public TransferRecurringCreateRequest isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The currency of the transfer amount. The default value is \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferRecurringCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="The description of the recurring transfer.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferRecurringCreateRequest testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid\u2019s unique identifier for a test clock. This field may only be used when using `sandbox` environment. If provided, the created `recurring_transfer` is associated with the `test_clock`. New originations are automatically generated when the associated `test_clock` advances.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public TransferRecurringCreateRequest schedule(TransferRecurringSchedule schedule) {
        this.schedule = schedule;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferRecurringSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(TransferRecurringSchedule schedule) {
        this.schedule = schedule;
    }

    public TransferRecurringCreateRequest user(TransferUserInRequest user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferUserInRequest getUser() {
        return this.user;
    }

    public void setUser(TransferUserInRequest user) {
        this.user = user;
    }

    public TransferRecurringCreateRequest device(TransferDevice device) {
        this.device = device;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TransferDevice getDevice() {
        return this.device;
    }

    public void setDevice(TransferDevice device) {
        this.device = device;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRecurringCreateRequest transferRecurringCreateRequest = (TransferRecurringCreateRequest)o;
        return Objects.equals(this.clientId, transferRecurringCreateRequest.clientId) && Objects.equals(this.secret, transferRecurringCreateRequest.secret) && Objects.equals(this.accessToken, transferRecurringCreateRequest.accessToken) && Objects.equals(this.idempotencyKey, transferRecurringCreateRequest.idempotencyKey) && Objects.equals(this.accountId, transferRecurringCreateRequest.accountId) && Objects.equals(this.fundingAccountId, transferRecurringCreateRequest.fundingAccountId) && Objects.equals((Object)this.type, (Object)transferRecurringCreateRequest.type) && Objects.equals((Object)this.network, (Object)transferRecurringCreateRequest.network) && Objects.equals((Object)this.achClass, (Object)transferRecurringCreateRequest.achClass) && Objects.equals(this.amount, transferRecurringCreateRequest.amount) && Objects.equals(this.userPresent, transferRecurringCreateRequest.userPresent) && Objects.equals(this.isoCurrencyCode, transferRecurringCreateRequest.isoCurrencyCode) && Objects.equals(this.description, transferRecurringCreateRequest.description) && Objects.equals(this.testClockId, transferRecurringCreateRequest.testClockId) && Objects.equals(this.schedule, transferRecurringCreateRequest.schedule) && Objects.equals(this.user, transferRecurringCreateRequest.user) && Objects.equals(this.device, transferRecurringCreateRequest.device);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.accessToken, this.idempotencyKey, this.accountId, this.fundingAccountId, this.type, this.network, this.achClass, this.amount, this.userPresent, this.isoCurrencyCode, this.description, this.testClockId, this.schedule, this.user, this.device});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRecurringCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    idempotencyKey: ").append(this.toIndentedString(this.idempotencyKey)).append("\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    network: ").append(this.toIndentedString((Object)this.network)).append("\n");
        sb.append("    achClass: ").append(this.toIndentedString((Object)this.achClass)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    userPresent: ").append(this.toIndentedString(this.userPresent)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("    schedule: ").append(this.toIndentedString(this.schedule)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

