/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/recurring/list`")
public class TransferRecurringListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private OffsetDateTime endTime;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;

    public TransferRecurringListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferRecurringListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferRecurringListRequest startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start datetime of recurring transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public TransferRecurringListRequest endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end datetime of recurring transfers to list. This should be in RFC 3339 format (i.e. `2019-12-06T22:35:49Z`)")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public TransferRecurringListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of recurring transfers to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public TransferRecurringListRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of recurring transfers to skip before returning results.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public TransferRecurringListRequest fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter recurring transfers to only those with the specified `funding_account_id`.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRecurringListRequest transferRecurringListRequest = (TransferRecurringListRequest)o;
        return Objects.equals(this.clientId, transferRecurringListRequest.clientId) && Objects.equals(this.secret, transferRecurringListRequest.secret) && Objects.equals(this.startTime, transferRecurringListRequest.startTime) && Objects.equals(this.endTime, transferRecurringListRequest.endTime) && Objects.equals(this.count, transferRecurringListRequest.count) && Objects.equals(this.offset, transferRecurringListRequest.offset) && Objects.equals(this.fundingAccountId, transferRecurringListRequest.fundingAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.startTime, this.endTime, this.count, this.offset, this.fundingAccountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRecurringListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

