/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferScheduleIntervalUnit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The schedule that the recurring transfer will be executed on.")
public class TransferRecurringSchedule {
    public static final String SERIALIZED_NAME_INTERVAL_UNIT = "interval_unit";
    @SerializedName(value="interval_unit")
    private TransferScheduleIntervalUnit intervalUnit;
    public static final String SERIALIZED_NAME_INTERVAL_COUNT = "interval_count";
    @SerializedName(value="interval_count")
    private Integer intervalCount;
    public static final String SERIALIZED_NAME_INTERVAL_EXECUTION_DAY = "interval_execution_day";
    @SerializedName(value="interval_execution_day")
    private Integer intervalExecutionDay;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;

    public TransferRecurringSchedule intervalUnit(TransferScheduleIntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferScheduleIntervalUnit getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(TransferScheduleIntervalUnit intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public TransferRecurringSchedule intervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of recurring `interval_units` between originations. The recurring interval (before holiday adjustment) is calculated by multiplying `interval_unit` and `interval_count`. For example, to schedule a recurring transfer which originates once every two weeks, set `interval_unit` = `week` and `interval_count` = 2.")
    public Integer getIntervalCount() {
        return this.intervalCount;
    }

    public void setIntervalCount(Integer intervalCount) {
        this.intervalCount = intervalCount;
    }

    public TransferRecurringSchedule intervalExecutionDay(Integer intervalExecutionDay) {
        this.intervalExecutionDay = intervalExecutionDay;
        return this;
    }

    @ApiModelProperty(required=true, value="The day of the interval on which to schedule the transfer.  If the `interval_unit` is `week`, `interval_execution_day` should be an integer from 1 (Monday) to 5 (Friday).  If the `interval_unit` is `month`, `interval_execution_day` should be an integer indicating which day of the month to make the transfer on. Integers from 1 to 28 can be used to make a transfer on that day of the month. Negative integers from -1 to -5 can be used to make a transfer relative to the end of the month. To make a transfer on the last day of the month, use -1; to make the transfer on the second-to-last day, use -2, and so on.  The transfer will be originated on the next available banking day if the designated day is a non banking day.")
    public Integer getIntervalExecutionDay() {
        return this.intervalExecutionDay;
    }

    public void setIntervalExecutionDay(Integer intervalExecutionDay) {
        this.intervalExecutionDay = intervalExecutionDay;
    }

    public TransferRecurringSchedule startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). The recurring transfer will begin on the first `interval_execution_day` on or after the `start_date`.  For `rtp` recurring transfers, `start_date` must be in the future. Otherwise, if the first `interval_execution_day` on or after the start date is also the same day that `/transfer/recurring/create` was called, the bank *may* make the first payment on that day, but it is not guaranteed to do so.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public TransferRecurringSchedule endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). The recurring transfer will end on the last `interval_execution_day` on or before the `end_date`. If the `interval_execution_day` between the start date and the end date (inclusive) is also the same day that `/transfer/recurring/create` was called, the bank *may* make a payment on that day, but it is not guaranteed to do so.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRecurringSchedule transferRecurringSchedule = (TransferRecurringSchedule)o;
        return Objects.equals((Object)this.intervalUnit, (Object)transferRecurringSchedule.intervalUnit) && Objects.equals(this.intervalCount, transferRecurringSchedule.intervalCount) && Objects.equals(this.intervalExecutionDay, transferRecurringSchedule.intervalExecutionDay) && Objects.equals(this.startDate, transferRecurringSchedule.startDate) && Objects.equals(this.endDate, transferRecurringSchedule.endDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.intervalUnit, this.intervalCount, this.intervalExecutionDay, this.startDate, this.endDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRecurringSchedule {\n");
        sb.append("    intervalUnit: ").append(this.toIndentedString((Object)this.intervalUnit)).append("\n");
        sb.append("    intervalCount: ").append(this.toIndentedString(this.intervalCount)).append("\n");
        sb.append("    intervalExecutionDay: ").append(this.toIndentedString(this.intervalExecutionDay)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

