/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.TransferRefundFailure;
import com.plaid.client.model.TransferRefundStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a refund within the Transfers API.")
public class TransferRefund {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private TransferRefundStatus status;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private TransferRefundFailure failureReason;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_NETWORK_TRACE_ID = "network_trace_id";
    @SerializedName(value="network_trace_id")
    private String networkTraceId;

    public TransferRefund id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a refund.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferRefund transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the transfer to refund.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransferRefund amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The amount of the refund (decimal string with two digits of precision e.g. \"10.00\").")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferRefund status(TransferRefundStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public TransferRefundStatus getStatus() {
        return this.status;
    }

    public void setStatus(TransferRefundStatus status) {
        this.status = status;
    }

    public TransferRefund failureReason(TransferRefundFailure failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public TransferRefundFailure getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(TransferRefundFailure failureReason) {
        this.failureReason = failureReason;
    }

    public TransferRefund created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when this refund was created. This will be of the form `2006-01-02T15:04:05Z`")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public TransferRefund networkTraceId(String networkTraceId) {
        this.networkTraceId = networkTraceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trace identifier for the transfer based on its network. This will only be set after the transfer has posted.  For `ach` or `same-day-ach` transfers, this is the ACH trace number. For `rtp` transfers, this is the Transaction Identification number. For `wire` transfers, this is the IMAD (Input Message Accountability Data) number.")
    public String getNetworkTraceId() {
        return this.networkTraceId;
    }

    public void setNetworkTraceId(String networkTraceId) {
        this.networkTraceId = networkTraceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRefund transferRefund = (TransferRefund)o;
        return Objects.equals(this.id, transferRefund.id) && Objects.equals(this.transferId, transferRefund.transferId) && Objects.equals(this.amount, transferRefund.amount) && Objects.equals((Object)this.status, (Object)transferRefund.status) && Objects.equals(this.failureReason, transferRefund.failureReason) && Objects.equals(this.created, transferRefund.created) && Objects.equals(this.networkTraceId, transferRefund.networkTraceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.transferId, this.amount, this.status, this.failureReason, this.created, this.networkTraceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRefund {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString(this.failureReason)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    networkTraceId: ").append(this.toIndentedString(this.networkTraceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

