/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The failure reason if the event type for a refund is `\"failed\"` or `\"returned\"`. Null value otherwise.")
public class TransferRefundFailure {
    public static final String SERIALIZED_NAME_ACH_RETURN_CODE = "ach_return_code";
    @SerializedName(value="ach_return_code")
    private String achReturnCode;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;

    public TransferRefundFailure achReturnCode(String achReturnCode) {
        this.achReturnCode = achReturnCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ACH return code, e.g. `R01`.  A return code will be provided if and only if the refund status is `returned`. For a full listing of ACH return codes, see [Transfer errors](https://plaid.com/docs/errors/transfer/#ach-return-codes).")
    public String getAchReturnCode() {
        return this.achReturnCode;
    }

    public void setAchReturnCode(String achReturnCode) {
        this.achReturnCode = achReturnCode;
    }

    public TransferRefundFailure description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable description of the reason for the failure or reversal.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRefundFailure transferRefundFailure = (TransferRefundFailure)o;
        return Objects.equals(this.achReturnCode, transferRefundFailure.achReturnCode) && Objects.equals(this.description, transferRefundFailure.description);
    }

    public int hashCode() {
        return Objects.hash(this.achReturnCode, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRefundFailure {\n");
        sb.append("    achReturnCode: ").append(this.toIndentedString(this.achReturnCode)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

