/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="A repayment is created automatically after one or more guaranteed transactions receive a return. If there are multiple eligible returns in a day, they are batched together into a single repayment.  Repayments are sent over ACH, with funds typically available on the next banking day.")
public class TransferRepayment {
    public static final String SERIALIZED_NAME_REPAYMENT_ID = "repayment_id";
    @SerializedName(value="repayment_id")
    private String repaymentId;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;

    public TransferRepayment repaymentId(String repaymentId) {
        this.repaymentId = repaymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the repayment.")
    public String getRepaymentId() {
        return this.repaymentId;
    }

    public void setRepaymentId(String repaymentId) {
        this.repaymentId = repaymentId;
    }

    public TransferRepayment created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when the repayment occurred, in RFC 3339 format.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public TransferRepayment amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Decimal amount of the repayment as it appears on your account ledger.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferRepayment isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the repayment, e.g. \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRepayment transferRepayment = (TransferRepayment)o;
        return Objects.equals(this.repaymentId, transferRepayment.repaymentId) && Objects.equals(this.created, transferRepayment.created) && Objects.equals(this.amount, transferRepayment.amount) && Objects.equals(this.isoCurrencyCode, transferRepayment.isoCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.repaymentId, this.created, this.amount, this.isoCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRepayment {\n");
        sb.append("    repaymentId: ").append(this.toIndentedString(this.repaymentId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

