/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a return on a Guaranteed ACH transfer that is included in the specified repayment.")
public class TransferRepaymentReturn {
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    private Integer eventId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;

    public TransferRepaymentReturn transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the guaranteed transfer that was returned.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransferRepaymentReturn eventId(Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the corresponding `returned` transfer event.")
    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(Integer eventId) {
        this.eventId = eventId;
    }

    public TransferRepaymentReturn amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the returned transfer.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferRepaymentReturn isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the repayment, e.g. \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRepaymentReturn transferRepaymentReturn = (TransferRepaymentReturn)o;
        return Objects.equals(this.transferId, transferRepaymentReturn.transferId) && Objects.equals(this.eventId, transferRepaymentReturn.eventId) && Objects.equals(this.amount, transferRepaymentReturn.amount) && Objects.equals(this.isoCurrencyCode, transferRepaymentReturn.isoCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.transferId, this.eventId, this.amount, this.isoCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRepaymentReturn {\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

