/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/repayment/return/list`")
public class TransferRepaymentReturnListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_REPAYMENT_ID = "repayment_id";
    @SerializedName(value="repayment_id")
    private String repaymentId;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;

    public TransferRepaymentReturnListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferRepaymentReturnListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferRepaymentReturnListRequest repaymentId(String repaymentId) {
        this.repaymentId = repaymentId;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the repayment to query.")
    public String getRepaymentId() {
        return this.repaymentId;
    }

    public void setRepaymentId(String repaymentId) {
        this.repaymentId = repaymentId;
    }

    public TransferRepaymentReturnListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of repayments to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public TransferRepaymentReturnListRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of repayments to skip before returning results.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRepaymentReturnListRequest transferRepaymentReturnListRequest = (TransferRepaymentReturnListRequest)o;
        return Objects.equals(this.clientId, transferRepaymentReturnListRequest.clientId) && Objects.equals(this.secret, transferRepaymentReturnListRequest.secret) && Objects.equals(this.repaymentId, transferRepaymentReturnListRequest.repaymentId) && Objects.equals(this.count, transferRepaymentReturnListRequest.count) && Objects.equals(this.offset, transferRepaymentReturnListRequest.offset);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.repaymentId, this.count, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRepaymentReturnListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    repaymentId: ").append(this.toIndentedString(this.repaymentId)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

