/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SweepStatus;
import com.plaid.client.model.SweepTrigger;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes a sweep of funds to / from the sweep account.  A sweep is associated with many sweep events (events of type `swept` or `return_swept`) which can be retrieved by invoking the `/transfer/event/list` endpoint with the corresponding `sweep_id`.  `swept` events occur when the transfer amount is credited or debited from your sweep account, depending on the `type` of the transfer. `return_swept` events occur when a transfer is returned and Plaid undoes the credit or debit.  The total sum of the `swept` and `return_swept` events is equal to the `amount` of the sweep Plaid creates and matches the amount of the entry on your sweep account ledger.")
public class TransferSweep {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_SETTLED = "settled";
    @SerializedName(value="settled")
    private LocalDate settled;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private SweepStatus status;
    public static final String SERIALIZED_NAME_TRIGGER = "trigger";
    @SerializedName(value="trigger")
    private SweepTrigger trigger;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_NETWORK_TRACE_ID = "network_trace_id";
    @SerializedName(value="network_trace_id")
    private String networkTraceId;

    public TransferSweep id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifier of the sweep.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TransferSweep fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The id of the funding account to use, available in the Plaid Dashboard. This determines which of your business checking accounts will be credited or debited.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferSweep created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(required=true, value="The datetime when the sweep occurred, in RFC 3339 format.")
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public TransferSweep amount(String amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="Signed decimal amount of the sweep as it appears on your sweep account ledger (e.g. \"-10.00\")  If amount is not present, the sweep was net-settled to zero and outstanding debits and credits between the sweep account and Plaid are balanced.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferSweep isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The currency of the sweep, e.g. \"USD\".")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public TransferSweep settled(LocalDate settled) {
        this.settled = settled;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The date when the sweep settled, in the YYYY-MM-DD format.")
    public LocalDate getSettled() {
        return this.settled;
    }

    public void setSettled(LocalDate settled) {
        this.settled = settled;
    }

    public TransferSweep status(SweepStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SweepStatus getStatus() {
        return this.status;
    }

    public void setStatus(SweepStatus status) {
        this.status = status;
    }

    public TransferSweep trigger(SweepTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SweepTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(SweepTrigger trigger) {
        this.trigger = trigger;
    }

    public TransferSweep description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The description of the deposit that will be passed to the receiving bank (up to 10 characters). Note that banks utilize this field differently, and may or may not show it on the bank statement.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferSweep networkTraceId(String networkTraceId) {
        this.networkTraceId = networkTraceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trace identifier for the transfer based on its network. This will only be set after the transfer has posted.  For `ach` or `same-day-ach` transfers, this is the ACH trace number. For `rtp` transfers, this is the Transaction Identification number. For `wire` transfers, this is the IMAD (Input Message Accountability Data) number.")
    public String getNetworkTraceId() {
        return this.networkTraceId;
    }

    public void setNetworkTraceId(String networkTraceId) {
        this.networkTraceId = networkTraceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferSweep transferSweep = (TransferSweep)o;
        return Objects.equals(this.id, transferSweep.id) && Objects.equals(this.fundingAccountId, transferSweep.fundingAccountId) && Objects.equals(this.created, transferSweep.created) && Objects.equals(this.amount, transferSweep.amount) && Objects.equals(this.isoCurrencyCode, transferSweep.isoCurrencyCode) && Objects.equals(this.settled, transferSweep.settled) && Objects.equals((Object)this.status, (Object)transferSweep.status) && Objects.equals((Object)this.trigger, (Object)transferSweep.trigger) && Objects.equals(this.description, transferSweep.description) && Objects.equals(this.networkTraceId, transferSweep.networkTraceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.fundingAccountId, this.created, this.amount, this.isoCurrencyCode, this.settled, this.status, this.trigger, this.description, this.networkTraceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferSweep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    settled: ").append(this.toIndentedString(this.settled)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString((Object)this.trigger)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    networkTraceId: ").append(this.toIndentedString(this.networkTraceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

