/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.SweepStatus;
import com.plaid.client.model.SweepTrigger;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the request schema for `/transfer/sweep/list`")
public class TransferSweepListRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private OffsetDateTime endDate;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count = 25;
    public static final String SERIALIZED_NAME_OFFSET = "offset";
    @SerializedName(value="offset")
    private Integer offset = 0;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private String amount;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private SweepStatus status;
    public static final String SERIALIZED_NAME_ORIGINATOR_CLIENT_ID = "originator_client_id";
    @SerializedName(value="originator_client_id")
    private String originatorClientId;
    public static final String SERIALIZED_NAME_FUNDING_ACCOUNT_ID = "funding_account_id";
    @SerializedName(value="funding_account_id")
    private String fundingAccountId;
    public static final String SERIALIZED_NAME_TRANSFER_ID = "transfer_id";
    @SerializedName(value="transfer_id")
    private String transferId;
    public static final String SERIALIZED_NAME_TRIGGER = "trigger";
    @SerializedName(value="trigger")
    private SweepTrigger trigger;

    public TransferSweepListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public TransferSweepListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public TransferSweepListRequest startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start datetime of sweeps to return (RFC 3339 format).")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public TransferSweepListRequest endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end datetime of sweeps to return (RFC 3339 format).")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public TransferSweepListRequest count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The maximum number of sweeps to return.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public TransferSweepListRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of sweeps to skip before returning results.")
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public TransferSweepListRequest amount(String amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter sweeps to only those with the specified amount.")
    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public TransferSweepListRequest status(SweepStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SweepStatus getStatus() {
        return this.status;
    }

    public void setStatus(SweepStatus status) {
        this.status = status;
    }

    public TransferSweepListRequest originatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter sweeps to only those with the specified originator client.")
    public String getOriginatorClientId() {
        return this.originatorClientId;
    }

    public void setOriginatorClientId(String originatorClientId) {
        this.originatorClientId = originatorClientId;
    }

    public TransferSweepListRequest fundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter sweeps to only those with the specified `funding_account_id`.")
    public String getFundingAccountId() {
        return this.fundingAccountId;
    }

    public void setFundingAccountId(String fundingAccountId) {
        this.fundingAccountId = fundingAccountId;
    }

    public TransferSweepListRequest transferId(String transferId) {
        this.transferId = transferId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter sweeps to only those with the included `transfer_id`.")
    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TransferSweepListRequest trigger(SweepTrigger trigger) {
        this.trigger = trigger;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SweepTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(SweepTrigger trigger) {
        this.trigger = trigger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferSweepListRequest transferSweepListRequest = (TransferSweepListRequest)o;
        return Objects.equals(this.clientId, transferSweepListRequest.clientId) && Objects.equals(this.secret, transferSweepListRequest.secret) && Objects.equals(this.startDate, transferSweepListRequest.startDate) && Objects.equals(this.endDate, transferSweepListRequest.endDate) && Objects.equals(this.count, transferSweepListRequest.count) && Objects.equals(this.offset, transferSweepListRequest.offset) && Objects.equals(this.amount, transferSweepListRequest.amount) && Objects.equals((Object)this.status, (Object)transferSweepListRequest.status) && Objects.equals(this.originatorClientId, transferSweepListRequest.originatorClientId) && Objects.equals(this.fundingAccountId, transferSweepListRequest.fundingAccountId) && Objects.equals(this.transferId, transferSweepListRequest.transferId) && Objects.equals((Object)this.trigger, (Object)transferSweepListRequest.trigger);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.startDate, this.endDate, this.count, this.offset, this.amount, this.status, this.originatorClientId, this.fundingAccountId, this.transferId, this.trigger});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferSweepListRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    originatorClientId: ").append(this.toIndentedString(this.originatorClientId)).append("\n");
        sb.append("    fundingAccountId: ").append(this.toIndentedString(this.fundingAccountId)).append("\n");
        sb.append("    transferId: ").append(this.toIndentedString(this.transferId)).append("\n");
        sb.append("    trigger: ").append(this.toIndentedString((Object)this.trigger)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

