/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@ApiModel(description="Defines the test clock for a transfer.")
public class TransferTestClock {
    public static final String SERIALIZED_NAME_TEST_CLOCK_ID = "test_clock_id";
    @SerializedName(value="test_clock_id")
    private String testClockId;
    public static final String SERIALIZED_NAME_VIRTUAL_TIME = "virtual_time";
    @SerializedName(value="virtual_time")
    private OffsetDateTime virtualTime;

    public TransferTestClock testClockId(String testClockId) {
        this.testClockId = testClockId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid\u2019s unique identifier for a test clock.")
    public String getTestClockId() {
        return this.testClockId;
    }

    public void setTestClockId(String testClockId) {
        this.testClockId = testClockId;
    }

    public TransferTestClock virtualTime(OffsetDateTime virtualTime) {
        this.virtualTime = virtualTime;
        return this;
    }

    @ApiModelProperty(required=true, value="The virtual timestamp on the test clock. This will be of the form `2006-01-02T15:04:05Z`.")
    public OffsetDateTime getVirtualTime() {
        return this.virtualTime;
    }

    public void setVirtualTime(OffsetDateTime virtualTime) {
        this.virtualTime = virtualTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferTestClock transferTestClock = (TransferTestClock)o;
        return Objects.equals(this.testClockId, transferTestClock.testClockId) && Objects.equals(this.virtualTime, transferTestClock.virtualTime);
    }

    public int hashCode() {
        return Objects.hash(this.testClockId, this.virtualTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferTestClock {\n");
        sb.append("    testClockId: ").append(this.toIndentedString(this.testClockId)).append("\n");
        sb.append("    virtualTime: ").append(this.toIndentedString(this.virtualTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

