/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The address associated with the account holder.")
public class TransferUserAddressInRequest {
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;

    public TransferUserAddressInRequest street(String street) {
        this.street = street;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The street number and name (i.e., \"100 Market St.\").")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public TransferUserAddressInRequest city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ex. \"San Francisco\"")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public TransferUserAddressInRequest region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state or province (e.g., \"CA\").")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public TransferUserAddressInRequest postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal code (e.g., \"94103\").")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public TransferUserAddressInRequest country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A two-letter country code (e.g., \"US\").")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferUserAddressInRequest transferUserAddressInRequest = (TransferUserAddressInRequest)o;
        return Objects.equals(this.street, transferUserAddressInRequest.street) && Objects.equals(this.city, transferUserAddressInRequest.city) && Objects.equals(this.region, transferUserAddressInRequest.region) && Objects.equals(this.postalCode, transferUserAddressInRequest.postalCode) && Objects.equals(this.country, transferUserAddressInRequest.country);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.city, this.region, this.postalCode, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferUserAddressInRequest {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

