/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.UserAccountIdentityAddress;
import com.plaid.client.model.UserAccountIdentityName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The identity data permissioned by the end user during the authorization flow.")
public class UserAccountIdentity {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private UserAccountIdentityName name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private UserAccountIdentityAddress address;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private String dateOfBirth;
    public static final String SERIALIZED_NAME_SSN = "ssn";
    @SerializedName(value="ssn")
    private String ssn;
    public static final String SERIALIZED_NAME_SSN_LAST4 = "ssn_last_4";
    @SerializedName(value="ssn_last_4")
    private String ssnLast4;

    public UserAccountIdentity name(UserAccountIdentityName name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserAccountIdentityName getName() {
        return this.name;
    }

    public void setName(UserAccountIdentityName name) {
        this.name = name;
    }

    public UserAccountIdentity address(UserAccountIdentityAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserAccountIdentityAddress getAddress() {
        return this.address;
    }

    public void setAddress(UserAccountIdentityAddress address) {
        this.address = address;
    }

    public UserAccountIdentity phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public UserAccountIdentity email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's email address.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserAccountIdentity dateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's date of birth.")
    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public UserAccountIdentity ssn(String ssn) {
        this.ssn = ssn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user's social security number.")
    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public UserAccountIdentity ssnLast4(String ssnLast4) {
        this.ssnLast4 = ssnLast4;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The last 4 digits of the user's social security number.")
    public String getSsnLast4() {
        return this.ssnLast4;
    }

    public void setSsnLast4(String ssnLast4) {
        this.ssnLast4 = ssnLast4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAccountIdentity userAccountIdentity = (UserAccountIdentity)o;
        return Objects.equals(this.name, userAccountIdentity.name) && Objects.equals(this.address, userAccountIdentity.address) && Objects.equals(this.phoneNumber, userAccountIdentity.phoneNumber) && Objects.equals(this.email, userAccountIdentity.email) && Objects.equals(this.dateOfBirth, userAccountIdentity.dateOfBirth) && Objects.equals(this.ssn, userAccountIdentity.ssn) && Objects.equals(this.ssnLast4, userAccountIdentity.ssnLast4);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.address, this.phoneNumber, this.email, this.dateOfBirth, this.ssn, this.ssnLast4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAccountIdentity {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    ssn: ").append(this.toIndentedString(this.ssn)).append("\n");
        sb.append("    ssnLast4: ").append(this.toIndentedString(this.ssnLast4)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

