/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The user's address.")
public class UserAccountIdentityAddress {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_REGION = "region";
    @SerializedName(value="region")
    private String region;
    public static final String SERIALIZED_NAME_STREET = "street";
    @SerializedName(value="street")
    private String street;
    public static final String SERIALIZED_NAME_STREET2 = "street2";
    @SerializedName(value="street2")
    private String street2;
    public static final String SERIALIZED_NAME_POSTAL_CODE = "postal_code";
    @SerializedName(value="postal_code")
    private String postalCode;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;

    public UserAccountIdentityAddress city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full city name")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public UserAccountIdentityAddress region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The region or state. Example: `\"NC\"`")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public UserAccountIdentityAddress street(String street) {
        this.street = street;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full street address Example: `\"564 Main Street, APT 15\"`")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public UserAccountIdentityAddress street2(String street2) {
        this.street2 = street2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The second line street address")
    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public UserAccountIdentityAddress postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal code. In API versions 2018-05-22 and earlier, this field is called `zip`.")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public UserAccountIdentityAddress country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166-1 alpha-2 country code")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAccountIdentityAddress userAccountIdentityAddress = (UserAccountIdentityAddress)o;
        return Objects.equals(this.city, userAccountIdentityAddress.city) && Objects.equals(this.region, userAccountIdentityAddress.region) && Objects.equals(this.street, userAccountIdentityAddress.street) && Objects.equals(this.street2, userAccountIdentityAddress.street2) && Objects.equals(this.postalCode, userAccountIdentityAddress.postalCode) && Objects.equals(this.country, userAccountIdentityAddress.country);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.region, this.street, this.street2, this.postalCode, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAccountIdentityAddress {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

