/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ConsumerReportUserIdentity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="UserCreateRequest defines the request schema for `/user/create`")
public class UserCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_CONSUMER_REPORT_USER_IDENTITY = "consumer_report_user_identity";
    @SerializedName(value="consumer_report_user_identity")
    private ConsumerReportUserIdentity consumerReportUserIdentity;

    public UserCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public UserCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public UserCreateRequest clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID representing the end user. Maximum of 128 characters. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public UserCreateRequest consumerReportUserIdentity(ConsumerReportUserIdentity consumerReportUserIdentity) {
        this.consumerReportUserIdentity = consumerReportUserIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ConsumerReportUserIdentity getConsumerReportUserIdentity() {
        return this.consumerReportUserIdentity;
    }

    public void setConsumerReportUserIdentity(ConsumerReportUserIdentity consumerReportUserIdentity) {
        this.consumerReportUserIdentity = consumerReportUserIdentity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCreateRequest userCreateRequest = (UserCreateRequest)o;
        return Objects.equals(this.clientId, userCreateRequest.clientId) && Objects.equals(this.secret, userCreateRequest.secret) && Objects.equals(this.clientUserId, userCreateRequest.clientUserId) && Objects.equals(this.consumerReportUserIdentity, userCreateRequest.consumerReportUserIdentity);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.clientUserId, this.consumerReportUserIdentity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    consumerReportUserIdentity: ").append(this.toIndentedString(this.consumerReportUserIdentity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

