/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="UserCreateResponse defines the response schema for `/user/create`")
public class UserCreateResponse {
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_USER_ID = "user_id";
    @SerializedName(value="user_id")
    private String userId;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public UserCreateResponse userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public UserCreateResponse userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `user_id` of the User associated with this webhook, warning, or error.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserCreateResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCreateResponse userCreateResponse = (UserCreateResponse)o;
        return Objects.equals(this.userToken, userCreateResponse.userToken) && Objects.equals(this.userId, userCreateResponse.userId) && Objects.equals(this.requestId, userCreateResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.userToken, this.userId, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCreateResponse {\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

