/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.MFA;
import com.plaid.client.model.OverrideAccounts;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Custom test accounts are configured with a JSON configuration object formulated according to the schema below. All top level fields are optional. Sending an empty object as a configuration will result in an account configured with random balances and transaction history.")
public class UserCustomPassword {
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_SEED = "seed";
    @SerializedName(value="seed")
    private String seed;
    public static final String SERIALIZED_NAME_OVERRIDE_ACCOUNTS = "override_accounts";
    @SerializedName(value="override_accounts")
    private List<OverrideAccounts> overrideAccounts = new ArrayList<OverrideAccounts>();
    public static final String SERIALIZED_NAME_MFA = "mfa";
    @SerializedName(value="mfa")
    private MFA mfa;
    public static final String SERIALIZED_NAME_RECAPTCHA = "recaptcha";
    @SerializedName(value="recaptcha")
    private String recaptcha;
    public static final String SERIALIZED_NAME_FORCE_ERROR = "force_error";
    @SerializedName(value="force_error")
    private String forceError;

    public UserCustomPassword version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version of the password schema to use, possible values are 1 or 2. The default value is 2. You should only specify 1 if you know it is necessary for your test suite.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public UserCustomPassword seed(String seed) {
        this.seed = seed;
        return this;
    }

    @ApiModelProperty(required=true, value="A seed, in the form of a string, that will be used to randomly generate account and transaction data, if this data is not specified using the `override_accounts` argument. If no seed is specified, the randomly generated data will be different each time.  Note that transactions data is generated relative to the Item's creation date. Different Items created on different dates with the same seed for transactions data will have different dates for the transactions. The number of days between each transaction and the Item creation will remain constant. For example, an Item created on December 15 might show a transaction on December 14. An Item created on December 20, using the same seed, would show that same transaction occurring on December 19.")
    public String getSeed() {
        return this.seed;
    }

    public void setSeed(String seed) {
        this.seed = seed;
    }

    public UserCustomPassword overrideAccounts(List<OverrideAccounts> overrideAccounts) {
        this.overrideAccounts = overrideAccounts;
        return this;
    }

    public UserCustomPassword addOverrideAccountsItem(OverrideAccounts overrideAccountsItem) {
        this.overrideAccounts.add(overrideAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of account overrides to configure the accounts for the Item. By default, if no override is specified, transactions and account data will be randomly generated based on the account type and subtype, and other products will have fixed or empty data.")
    public List<OverrideAccounts> getOverrideAccounts() {
        return this.overrideAccounts;
    }

    public void setOverrideAccounts(List<OverrideAccounts> overrideAccounts) {
        this.overrideAccounts = overrideAccounts;
    }

    public UserCustomPassword mfa(MFA mfa) {
        this.mfa = mfa;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MFA getMfa() {
        return this.mfa;
    }

    public void setMfa(MFA mfa) {
        this.mfa = mfa;
    }

    public UserCustomPassword recaptcha(String recaptcha) {
        this.recaptcha = recaptcha;
        return this;
    }

    @ApiModelProperty(required=true, value="You may trigger a reCAPTCHA in Plaid Link in the Sandbox environment by using the recaptcha field. Possible values are `good` or `bad`. A value of `good` will result in successful Item creation and `bad` will result in a `RECAPTCHA_BAD` error to simulate a failed reCAPTCHA. Both values require the reCAPTCHA to be manually solved within Plaid Link.")
    public String getRecaptcha() {
        return this.recaptcha;
    }

    public void setRecaptcha(String recaptcha) {
        this.recaptcha = recaptcha;
    }

    public UserCustomPassword forceError(String forceError) {
        this.forceError = forceError;
        return this;
    }

    @ApiModelProperty(required=true, value="An error code to force on Item creation. Possible values are:  `\"INSTITUTION_NOT_RESPONDING\"` `\"INSTITUTION_NO_LONGER_SUPPORTED\"` `\"INVALID_CREDENTIALS\"` `\"INVALID_MFA\"` `\"ITEM_LOCKED\"` `\"ITEM_LOGIN_REQUIRED\"` `\"ITEM_NOT_SUPPORTED\"` `\"INVALID_LINK_TOKEN\"` `\"MFA_NOT_SUPPORTED\"` `\"NO_ACCOUNTS\"` `\"PLAID_ERROR\"` `\"USER_INPUT_TIMEOUT\"` `\"USER_SETUP_REQUIRED\"`")
    public String getForceError() {
        return this.forceError;
    }

    public void setForceError(String forceError) {
        this.forceError = forceError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserCustomPassword userCustomPassword = (UserCustomPassword)o;
        return Objects.equals(this.version, userCustomPassword.version) && Objects.equals(this.seed, userCustomPassword.seed) && Objects.equals(this.overrideAccounts, userCustomPassword.overrideAccounts) && Objects.equals(this.mfa, userCustomPassword.mfa) && Objects.equals(this.recaptcha, userCustomPassword.recaptcha) && Objects.equals(this.forceError, userCustomPassword.forceError);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.seed, this.overrideAccounts, this.mfa, this.recaptcha, this.forceError);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserCustomPassword {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    seed: ").append(this.toIndentedString(this.seed)).append("\n");
        sb.append("    overrideAccounts: ").append(this.toIndentedString(this.overrideAccounts)).append("\n");
        sb.append("    mfa: ").append(this.toIndentedString(this.mfa)).append("\n");
        sb.append("    recaptcha: ").append(this.toIndentedString(this.recaptcha)).append("\n");
        sb.append("    forceError: ").append(this.toIndentedString(this.forceError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

