/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="metadata for the set of insights provided in `TransactionsUserInsightsGetResponse`")
public class UserDataOverview {
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_OLDEST_TRANSACTION_DATE = "oldest_transaction_date";
    @SerializedName(value="oldest_transaction_date")
    private LocalDate oldestTransactionDate;
    public static final String SERIALIZED_NAME_NEWEST_TRANSACTION_DATE = "newest_transaction_date";
    @SerializedName(value="newest_transaction_date")
    private LocalDate newestTransactionDate;
    public static final String SERIALIZED_NAME_DAYS_AVAILABLE = "days_available";
    @SerializedName(value="days_available")
    private Integer daysAvailable;
    public static final String SERIALIZED_NAME_TOTAL_OUTFLOWS = "total_outflows";
    @SerializedName(value="total_outflows")
    private Double totalOutflows;
    public static final String SERIALIZED_NAME_TOTAL_INFLOWS = "total_inflows";
    @SerializedName(value="total_inflows")
    private Double totalInflows;

    public UserDataOverview transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of transactions.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public UserDataOverview oldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date of the oldest transaction processed to generate insights.")
    public LocalDate getOldestTransactionDate() {
        return this.oldestTransactionDate;
    }

    public void setOldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
    }

    public UserDataOverview newestTransactionDate(LocalDate newestTransactionDate) {
        this.newestTransactionDate = newestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date of the newest transaction processed to generate insights.")
    public LocalDate getNewestTransactionDate() {
        return this.newestTransactionDate;
    }

    public void setNewestTransactionDate(LocalDate newestTransactionDate) {
        this.newestTransactionDate = newestTransactionDate;
    }

    public UserDataOverview daysAvailable(Integer daysAvailable) {
        this.daysAvailable = daysAvailable;
        return this;
    }

    @ApiModelProperty(required=true, value="The range of days of transactions available.")
    public Integer getDaysAvailable() {
        return this.daysAvailable;
    }

    public void setDaysAvailable(Integer daysAvailable) {
        this.daysAvailable = daysAvailable;
    }

    public UserDataOverview totalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of outflow amounts.")
    public Double getTotalOutflows() {
        return this.totalOutflows;
    }

    public void setTotalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
    }

    public UserDataOverview totalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of inflow amounts.")
    public Double getTotalInflows() {
        return this.totalInflows;
    }

    public void setTotalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserDataOverview userDataOverview = (UserDataOverview)o;
        return Objects.equals(this.transactionCount, userDataOverview.transactionCount) && Objects.equals(this.oldestTransactionDate, userDataOverview.oldestTransactionDate) && Objects.equals(this.newestTransactionDate, userDataOverview.newestTransactionDate) && Objects.equals(this.daysAvailable, userDataOverview.daysAvailable) && Objects.equals(this.totalOutflows, userDataOverview.totalOutflows) && Objects.equals(this.totalInflows, userDataOverview.totalInflows);
    }

    public int hashCode() {
        return Objects.hash(this.transactionCount, this.oldestTransactionDate, this.newestTransactionDate, this.daysAvailable, this.totalOutflows, this.totalInflows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserDataOverview {\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    oldestTransactionDate: ").append(this.toIndentedString(this.oldestTransactionDate)).append("\n");
        sb.append("    newestTransactionDate: ").append(this.toIndentedString(this.newestTransactionDate)).append("\n");
        sb.append("    daysAvailable: ").append(this.toIndentedString(this.daysAvailable)).append("\n");
        sb.append("    totalOutflows: ").append(this.toIndentedString(this.totalOutflows)).append("\n");
        sb.append("    totalInflows: ").append(this.toIndentedString(this.totalInflows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

