/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IDNumberType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ID number submitted by the user, currently used only for the Identity Verification product. If the user has not submitted this data yet, this field will be `null`. Otherwise, both fields are guaranteed to be filled.")
public class UserIDNumber {
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private IDNumberType type;

    public UserIDNumber value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="123456789", required=true, value="Value of identity document value typed in by user. Alpha-numeric, with all formatting characters stripped. For specific format requirements by ID type, see [Hybrid Input Validation](https://plaid.com/docs/identity-verification/hybrid-input-validation/).")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public UserIDNumber type(IDNumberType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public IDNumberType getType() {
        return this.type;
    }

    public void setType(IDNumberType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIDNumber userIDNumber = (UserIDNumber)o;
        return Objects.equals(this.value, userIDNumber.value) && Objects.equals((Object)this.type, (Object)userIDNumber.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserIDNumber {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

