/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ConsumerReportUserIdentity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="UserUpdateRequest defines the request schema for `/user/update`")
public class UserUpdateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_USER_TOKEN = "user_token";
    @SerializedName(value="user_token")
    private String userToken;
    public static final String SERIALIZED_NAME_CONSUMER_REPORT_USER_IDENTITY = "consumer_report_user_identity";
    @SerializedName(value="consumer_report_user_identity")
    private ConsumerReportUserIdentity consumerReportUserIdentity;

    public UserUpdateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public UserUpdateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public UserUpdateRequest userToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The user token associated with the User data is being requested for.")
    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public UserUpdateRequest consumerReportUserIdentity(ConsumerReportUserIdentity consumerReportUserIdentity) {
        this.consumerReportUserIdentity = consumerReportUserIdentity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ConsumerReportUserIdentity getConsumerReportUserIdentity() {
        return this.consumerReportUserIdentity;
    }

    public void setConsumerReportUserIdentity(ConsumerReportUserIdentity consumerReportUserIdentity) {
        this.consumerReportUserIdentity = consumerReportUserIdentity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserUpdateRequest userUpdateRequest = (UserUpdateRequest)o;
        return Objects.equals(this.clientId, userUpdateRequest.clientId) && Objects.equals(this.secret, userUpdateRequest.secret) && Objects.equals(this.userToken, userUpdateRequest.userToken) && Objects.equals(this.consumerReportUserIdentity, userUpdateRequest.consumerReportUserIdentity);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.userToken, this.consumerReportUserIdentity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserUpdateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    userToken: ").append(this.toIndentedString(this.userToken)).append("\n");
        sb.append("    consumerReportUserIdentity: ").append(this.toIndentedString(this.consumerReportUserIdentity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

