/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Employee;
import com.plaid.client.model.PaystubEmployer;
import com.plaid.client.model.W2Box12;
import com.plaid.client.model.W2StateAndLocalWages;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="W2 is an object that represents income data taken from a W2 tax document.")
public class W2 {
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private PaystubEmployer employer;
    public static final String SERIALIZED_NAME_EMPLOYEE = "employee";
    @SerializedName(value="employee")
    private Employee employee;
    public static final String SERIALIZED_NAME_TAX_YEAR = "tax_year";
    @SerializedName(value="tax_year")
    private String taxYear;
    public static final String SERIALIZED_NAME_EMPLOYER_ID_NUMBER = "employer_id_number";
    @SerializedName(value="employer_id_number")
    private String employerIdNumber;
    public static final String SERIALIZED_NAME_WAGES_TIPS_OTHER_COMP = "wages_tips_other_comp";
    @SerializedName(value="wages_tips_other_comp")
    private String wagesTipsOtherComp;
    public static final String SERIALIZED_NAME_FEDERAL_INCOME_TAX_WITHHELD = "federal_income_tax_withheld";
    @SerializedName(value="federal_income_tax_withheld")
    private String federalIncomeTaxWithheld;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_WAGES = "social_security_wages";
    @SerializedName(value="social_security_wages")
    private String socialSecurityWages;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_TAX_WITHHELD = "social_security_tax_withheld";
    @SerializedName(value="social_security_tax_withheld")
    private String socialSecurityTaxWithheld;
    public static final String SERIALIZED_NAME_MEDICARE_WAGES_AND_TIPS = "medicare_wages_and_tips";
    @SerializedName(value="medicare_wages_and_tips")
    private String medicareWagesAndTips;
    public static final String SERIALIZED_NAME_MEDICARE_TAX_WITHHELD = "medicare_tax_withheld";
    @SerializedName(value="medicare_tax_withheld")
    private String medicareTaxWithheld;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_TIPS = "social_security_tips";
    @SerializedName(value="social_security_tips")
    private String socialSecurityTips;
    public static final String SERIALIZED_NAME_ALLOCATED_TIPS = "allocated_tips";
    @SerializedName(value="allocated_tips")
    private String allocatedTips;
    public static final String SERIALIZED_NAME_BOX9 = "box_9";
    @SerializedName(value="box_9")
    private String box9;
    public static final String SERIALIZED_NAME_DEPENDENT_CARE_BENEFITS = "dependent_care_benefits";
    @SerializedName(value="dependent_care_benefits")
    private String dependentCareBenefits;
    public static final String SERIALIZED_NAME_NONQUALIFIED_PLANS = "nonqualified_plans";
    @SerializedName(value="nonqualified_plans")
    private String nonqualifiedPlans;
    public static final String SERIALIZED_NAME_BOX12 = "box_12";
    @SerializedName(value="box_12")
    private List<W2Box12> box12 = null;
    public static final String SERIALIZED_NAME_STATUTORY_EMPLOYEE = "statutory_employee";
    @SerializedName(value="statutory_employee")
    private String statutoryEmployee;
    public static final String SERIALIZED_NAME_RETIREMENT_PLAN = "retirement_plan";
    @SerializedName(value="retirement_plan")
    private String retirementPlan;
    public static final String SERIALIZED_NAME_THIRD_PARTY_SICK_PAY = "third_party_sick_pay";
    @SerializedName(value="third_party_sick_pay")
    private String thirdPartySickPay;
    public static final String SERIALIZED_NAME_OTHER = "other";
    @SerializedName(value="other")
    private String other;
    public static final String SERIALIZED_NAME_STATE_AND_LOCAL_WAGES = "state_and_local_wages";
    @SerializedName(value="state_and_local_wages")
    private List<W2StateAndLocalWages> stateAndLocalWages = null;

    public W2 employer(PaystubEmployer employer) {
        this.employer = employer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaystubEmployer getEmployer() {
        return this.employer;
    }

    public void setEmployer(PaystubEmployer employer) {
        this.employer = employer;
    }

    public W2 employee(Employee employee) {
        this.employee = employee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public W2 taxYear(String taxYear) {
        this.taxYear = taxYear;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tax year of the W2 document.")
    public String getTaxYear() {
        return this.taxYear;
    }

    public void setTaxYear(String taxYear) {
        this.taxYear = taxYear;
    }

    public W2 employerIdNumber(String employerIdNumber) {
        this.employerIdNumber = employerIdNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An employee identification number or EIN.")
    public String getEmployerIdNumber() {
        return this.employerIdNumber;
    }

    public void setEmployerIdNumber(String employerIdNumber) {
        this.employerIdNumber = employerIdNumber;
    }

    public W2 wagesTipsOtherComp(String wagesTipsOtherComp) {
        this.wagesTipsOtherComp = wagesTipsOtherComp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wages from tips and other compensation.")
    public String getWagesTipsOtherComp() {
        return this.wagesTipsOtherComp;
    }

    public void setWagesTipsOtherComp(String wagesTipsOtherComp) {
        this.wagesTipsOtherComp = wagesTipsOtherComp;
    }

    public W2 federalIncomeTaxWithheld(String federalIncomeTaxWithheld) {
        this.federalIncomeTaxWithheld = federalIncomeTaxWithheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Federal income tax withheld for the tax year.")
    public String getFederalIncomeTaxWithheld() {
        return this.federalIncomeTaxWithheld;
    }

    public void setFederalIncomeTaxWithheld(String federalIncomeTaxWithheld) {
        this.federalIncomeTaxWithheld = federalIncomeTaxWithheld;
    }

    public W2 socialSecurityWages(String socialSecurityWages) {
        this.socialSecurityWages = socialSecurityWages;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wages from social security.")
    public String getSocialSecurityWages() {
        return this.socialSecurityWages;
    }

    public void setSocialSecurityWages(String socialSecurityWages) {
        this.socialSecurityWages = socialSecurityWages;
    }

    public W2 socialSecurityTaxWithheld(String socialSecurityTaxWithheld) {
        this.socialSecurityTaxWithheld = socialSecurityTaxWithheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Social security tax withheld for the tax year.")
    public String getSocialSecurityTaxWithheld() {
        return this.socialSecurityTaxWithheld;
    }

    public void setSocialSecurityTaxWithheld(String socialSecurityTaxWithheld) {
        this.socialSecurityTaxWithheld = socialSecurityTaxWithheld;
    }

    public W2 medicareWagesAndTips(String medicareWagesAndTips) {
        this.medicareWagesAndTips = medicareWagesAndTips;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wages and tips from medicare.")
    public String getMedicareWagesAndTips() {
        return this.medicareWagesAndTips;
    }

    public void setMedicareWagesAndTips(String medicareWagesAndTips) {
        this.medicareWagesAndTips = medicareWagesAndTips;
    }

    public W2 medicareTaxWithheld(String medicareTaxWithheld) {
        this.medicareTaxWithheld = medicareTaxWithheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Medicare tax withheld for the tax year.")
    public String getMedicareTaxWithheld() {
        return this.medicareTaxWithheld;
    }

    public void setMedicareTaxWithheld(String medicareTaxWithheld) {
        this.medicareTaxWithheld = medicareTaxWithheld;
    }

    public W2 socialSecurityTips(String socialSecurityTips) {
        this.socialSecurityTips = socialSecurityTips;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tips from social security.")
    public String getSocialSecurityTips() {
        return this.socialSecurityTips;
    }

    public void setSocialSecurityTips(String socialSecurityTips) {
        this.socialSecurityTips = socialSecurityTips;
    }

    public W2 allocatedTips(String allocatedTips) {
        this.allocatedTips = allocatedTips;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allocated tips.")
    public String getAllocatedTips() {
        return this.allocatedTips;
    }

    public void setAllocatedTips(String allocatedTips) {
        this.allocatedTips = allocatedTips;
    }

    public W2 box9(String box9) {
        this.box9 = box9;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contents from box 9 on the W2.")
    public String getBox9() {
        return this.box9;
    }

    public void setBox9(String box9) {
        this.box9 = box9;
    }

    public W2 dependentCareBenefits(String dependentCareBenefits) {
        this.dependentCareBenefits = dependentCareBenefits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Dependent care benefits.")
    public String getDependentCareBenefits() {
        return this.dependentCareBenefits;
    }

    public void setDependentCareBenefits(String dependentCareBenefits) {
        this.dependentCareBenefits = dependentCareBenefits;
    }

    public W2 nonqualifiedPlans(String nonqualifiedPlans) {
        this.nonqualifiedPlans = nonqualifiedPlans;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Nonqualified plans.")
    public String getNonqualifiedPlans() {
        return this.nonqualifiedPlans;
    }

    public void setNonqualifiedPlans(String nonqualifiedPlans) {
        this.nonqualifiedPlans = nonqualifiedPlans;
    }

    public W2 box12(List<W2Box12> box12) {
        this.box12 = box12;
        return this;
    }

    public W2 addBox12Item(W2Box12 box12Item) {
        if (this.box12 == null) {
            this.box12 = new ArrayList<W2Box12>();
        }
        this.box12.add(box12Item);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<W2Box12> getBox12() {
        return this.box12;
    }

    public void setBox12(List<W2Box12> box12) {
        this.box12 = box12;
    }

    public W2 statutoryEmployee(String statutoryEmployee) {
        this.statutoryEmployee = statutoryEmployee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Statutory employee.")
    public String getStatutoryEmployee() {
        return this.statutoryEmployee;
    }

    public void setStatutoryEmployee(String statutoryEmployee) {
        this.statutoryEmployee = statutoryEmployee;
    }

    public W2 retirementPlan(String retirementPlan) {
        this.retirementPlan = retirementPlan;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Retirement plan.")
    public String getRetirementPlan() {
        return this.retirementPlan;
    }

    public void setRetirementPlan(String retirementPlan) {
        this.retirementPlan = retirementPlan;
    }

    public W2 thirdPartySickPay(String thirdPartySickPay) {
        this.thirdPartySickPay = thirdPartySickPay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Third party sick pay.")
    public String getThirdPartySickPay() {
        return this.thirdPartySickPay;
    }

    public void setThirdPartySickPay(String thirdPartySickPay) {
        this.thirdPartySickPay = thirdPartySickPay;
    }

    public W2 other(String other) {
        this.other = other;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Other.")
    public String getOther() {
        return this.other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public W2 stateAndLocalWages(List<W2StateAndLocalWages> stateAndLocalWages) {
        this.stateAndLocalWages = stateAndLocalWages;
        return this;
    }

    public W2 addStateAndLocalWagesItem(W2StateAndLocalWages stateAndLocalWagesItem) {
        if (this.stateAndLocalWages == null) {
            this.stateAndLocalWages = new ArrayList<W2StateAndLocalWages>();
        }
        this.stateAndLocalWages.add(stateAndLocalWagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<W2StateAndLocalWages> getStateAndLocalWages() {
        return this.stateAndLocalWages;
    }

    public void setStateAndLocalWages(List<W2StateAndLocalWages> stateAndLocalWages) {
        this.stateAndLocalWages = stateAndLocalWages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        W2 W22 = (W2)o;
        return Objects.equals(this.employer, W22.employer) && Objects.equals(this.employee, W22.employee) && Objects.equals(this.taxYear, W22.taxYear) && Objects.equals(this.employerIdNumber, W22.employerIdNumber) && Objects.equals(this.wagesTipsOtherComp, W22.wagesTipsOtherComp) && Objects.equals(this.federalIncomeTaxWithheld, W22.federalIncomeTaxWithheld) && Objects.equals(this.socialSecurityWages, W22.socialSecurityWages) && Objects.equals(this.socialSecurityTaxWithheld, W22.socialSecurityTaxWithheld) && Objects.equals(this.medicareWagesAndTips, W22.medicareWagesAndTips) && Objects.equals(this.medicareTaxWithheld, W22.medicareTaxWithheld) && Objects.equals(this.socialSecurityTips, W22.socialSecurityTips) && Objects.equals(this.allocatedTips, W22.allocatedTips) && Objects.equals(this.box9, W22.box9) && Objects.equals(this.dependentCareBenefits, W22.dependentCareBenefits) && Objects.equals(this.nonqualifiedPlans, W22.nonqualifiedPlans) && Objects.equals(this.box12, W22.box12) && Objects.equals(this.statutoryEmployee, W22.statutoryEmployee) && Objects.equals(this.retirementPlan, W22.retirementPlan) && Objects.equals(this.thirdPartySickPay, W22.thirdPartySickPay) && Objects.equals(this.other, W22.other) && Objects.equals(this.stateAndLocalWages, W22.stateAndLocalWages);
    }

    public int hashCode() {
        return Objects.hash(this.employer, this.employee, this.taxYear, this.employerIdNumber, this.wagesTipsOtherComp, this.federalIncomeTaxWithheld, this.socialSecurityWages, this.socialSecurityTaxWithheld, this.medicareWagesAndTips, this.medicareTaxWithheld, this.socialSecurityTips, this.allocatedTips, this.box9, this.dependentCareBenefits, this.nonqualifiedPlans, this.box12, this.statutoryEmployee, this.retirementPlan, this.thirdPartySickPay, this.other, this.stateAndLocalWages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class W2 {\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    employee: ").append(this.toIndentedString(this.employee)).append("\n");
        sb.append("    taxYear: ").append(this.toIndentedString(this.taxYear)).append("\n");
        sb.append("    employerIdNumber: ").append(this.toIndentedString(this.employerIdNumber)).append("\n");
        sb.append("    wagesTipsOtherComp: ").append(this.toIndentedString(this.wagesTipsOtherComp)).append("\n");
        sb.append("    federalIncomeTaxWithheld: ").append(this.toIndentedString(this.federalIncomeTaxWithheld)).append("\n");
        sb.append("    socialSecurityWages: ").append(this.toIndentedString(this.socialSecurityWages)).append("\n");
        sb.append("    socialSecurityTaxWithheld: ").append(this.toIndentedString(this.socialSecurityTaxWithheld)).append("\n");
        sb.append("    medicareWagesAndTips: ").append(this.toIndentedString(this.medicareWagesAndTips)).append("\n");
        sb.append("    medicareTaxWithheld: ").append(this.toIndentedString(this.medicareTaxWithheld)).append("\n");
        sb.append("    socialSecurityTips: ").append(this.toIndentedString(this.socialSecurityTips)).append("\n");
        sb.append("    allocatedTips: ").append(this.toIndentedString(this.allocatedTips)).append("\n");
        sb.append("    box9: ").append(this.toIndentedString(this.box9)).append("\n");
        sb.append("    dependentCareBenefits: ").append(this.toIndentedString(this.dependentCareBenefits)).append("\n");
        sb.append("    nonqualifiedPlans: ").append(this.toIndentedString(this.nonqualifiedPlans)).append("\n");
        sb.append("    box12: ").append(this.toIndentedString(this.box12)).append("\n");
        sb.append("    statutoryEmployee: ").append(this.toIndentedString(this.statutoryEmployee)).append("\n");
        sb.append("    retirementPlan: ").append(this.toIndentedString(this.retirementPlan)).append("\n");
        sb.append("    thirdPartySickPay: ").append(this.toIndentedString(this.thirdPartySickPay)).append("\n");
        sb.append("    other: ").append(this.toIndentedString(this.other)).append("\n");
        sb.append("    stateAndLocalWages: ").append(this.toIndentedString(this.stateAndLocalWages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

