/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="W2 state and local wages")
public class W2StateAndLocalWagesOverride {
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    public static final String SERIALIZED_NAME_EMPLOYER_STATE_ID_NUMBER = "employer_state_id_number";
    @SerializedName(value="employer_state_id_number")
    private String employerStateIdNumber;
    public static final String SERIALIZED_NAME_STATE_WAGES_TIPS = "state_wages_tips";
    @SerializedName(value="state_wages_tips")
    private String stateWagesTips;
    public static final String SERIALIZED_NAME_STATE_INCOME_TAX = "state_income_tax";
    @SerializedName(value="state_income_tax")
    private String stateIncomeTax;
    public static final String SERIALIZED_NAME_LOCAL_WAGES_TIPS = "local_wages_tips";
    @SerializedName(value="local_wages_tips")
    private String localWagesTips;
    public static final String SERIALIZED_NAME_LOCAL_INCOME_TAX = "local_income_tax";
    @SerializedName(value="local_income_tax")
    private String localIncomeTax;
    public static final String SERIALIZED_NAME_LOCALITY_NAME = "locality_name";
    @SerializedName(value="locality_name")
    private String localityName;

    public W2StateAndLocalWagesOverride state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State associated with the wage.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public W2StateAndLocalWagesOverride employerStateIdNumber(String employerStateIdNumber) {
        this.employerStateIdNumber = employerStateIdNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State identification number of the employer.")
    public String getEmployerStateIdNumber() {
        return this.employerStateIdNumber;
    }

    public void setEmployerStateIdNumber(String employerStateIdNumber) {
        this.employerStateIdNumber = employerStateIdNumber;
    }

    public W2StateAndLocalWagesOverride stateWagesTips(String stateWagesTips) {
        this.stateWagesTips = stateWagesTips;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wages and tips from the specified state.")
    public String getStateWagesTips() {
        return this.stateWagesTips;
    }

    public void setStateWagesTips(String stateWagesTips) {
        this.stateWagesTips = stateWagesTips;
    }

    public W2StateAndLocalWagesOverride stateIncomeTax(String stateIncomeTax) {
        this.stateIncomeTax = stateIncomeTax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Income tax from the specified state.")
    public String getStateIncomeTax() {
        return this.stateIncomeTax;
    }

    public void setStateIncomeTax(String stateIncomeTax) {
        this.stateIncomeTax = stateIncomeTax;
    }

    public W2StateAndLocalWagesOverride localWagesTips(String localWagesTips) {
        this.localWagesTips = localWagesTips;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wages and tips from the locality.")
    public String getLocalWagesTips() {
        return this.localWagesTips;
    }

    public void setLocalWagesTips(String localWagesTips) {
        this.localWagesTips = localWagesTips;
    }

    public W2StateAndLocalWagesOverride localIncomeTax(String localIncomeTax) {
        this.localIncomeTax = localIncomeTax;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Income tax from the locality.")
    public String getLocalIncomeTax() {
        return this.localIncomeTax;
    }

    public void setLocalIncomeTax(String localIncomeTax) {
        this.localIncomeTax = localIncomeTax;
    }

    public W2StateAndLocalWagesOverride localityName(String localityName) {
        this.localityName = localityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the locality.")
    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String localityName) {
        this.localityName = localityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        W2StateAndLocalWagesOverride w2StateAndLocalWagesOverride = (W2StateAndLocalWagesOverride)o;
        return Objects.equals(this.state, w2StateAndLocalWagesOverride.state) && Objects.equals(this.employerStateIdNumber, w2StateAndLocalWagesOverride.employerStateIdNumber) && Objects.equals(this.stateWagesTips, w2StateAndLocalWagesOverride.stateWagesTips) && Objects.equals(this.stateIncomeTax, w2StateAndLocalWagesOverride.stateIncomeTax) && Objects.equals(this.localWagesTips, w2StateAndLocalWagesOverride.localWagesTips) && Objects.equals(this.localIncomeTax, w2StateAndLocalWagesOverride.localIncomeTax) && Objects.equals(this.localityName, w2StateAndLocalWagesOverride.localityName);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.employerStateIdNumber, this.stateWagesTips, this.stateIncomeTax, this.localWagesTips, this.localIncomeTax, this.localityName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class W2StateAndLocalWagesOverride {\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    employerStateIdNumber: ").append(this.toIndentedString(this.employerStateIdNumber)).append("\n");
        sb.append("    stateWagesTips: ").append(this.toIndentedString(this.stateWagesTips)).append("\n");
        sb.append("    stateIncomeTax: ").append(this.toIndentedString(this.stateIncomeTax)).append("\n");
        sb.append("    localWagesTips: ").append(this.toIndentedString(this.localWagesTips)).append("\n");
        sb.append("    localIncomeTax: ").append(this.toIndentedString(this.localIncomeTax)).append("\n");
        sb.append("    localityName: ").append(this.toIndentedString(this.localityName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

