/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WalletBalance;
import com.plaid.client.model.WalletNumbers;
import com.plaid.client.model.WalletStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the e-wallet")
public class Wallet {
    public static final String SERIALIZED_NAME_WALLET_ID = "wallet_id";
    @SerializedName(value="wallet_id")
    private String walletId;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private WalletBalance balance;
    public static final String SERIALIZED_NAME_NUMBERS = "numbers";
    @SerializedName(value="numbers")
    private WalletNumbers numbers;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    private String recipientId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WalletStatus status;

    public Wallet walletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID identifying the e-wallet")
    public String getWalletId() {
        return this.walletId;
    }

    public void setWalletId(String walletId) {
        this.walletId = walletId;
    }

    public Wallet balance(WalletBalance balance) {
        this.balance = balance;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletBalance getBalance() {
        return this.balance;
    }

    public void setBalance(WalletBalance balance) {
        this.balance = balance;
    }

    public Wallet numbers(WalletNumbers numbers) {
        this.numbers = numbers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletNumbers getNumbers() {
        return this.numbers;
    }

    public void setNumbers(WalletNumbers numbers) {
        this.numbers = numbers;
    }

    public Wallet recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the recipient that corresponds to the e-wallet account numbers")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public Wallet status(WalletStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletStatus getStatus() {
        return this.status;
    }

    public void setStatus(WalletStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Wallet wallet = (Wallet)o;
        return Objects.equals(this.walletId, wallet.walletId) && Objects.equals(this.balance, wallet.balance) && Objects.equals(this.numbers, wallet.numbers) && Objects.equals(this.recipientId, wallet.recipientId) && Objects.equals((Object)this.status, (Object)wallet.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.walletId, this.balance, this.numbers, this.recipientId, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Wallet {\n");
        sb.append("    walletId: ").append(this.toIndentedString(this.walletId)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    numbers: ").append(this.toIndentedString(this.numbers)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

