/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An object representing the e-wallet balance")
public class WalletBalance {
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private Double current;
    public static final String SERIALIZED_NAME_AVAILABLE = "available";
    @SerializedName(value="available")
    private Double available;

    public WalletBalance isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the balance")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public WalletBalance current(Double current) {
        this.current = current;
        return this;
    }

    @ApiModelProperty(required=true, value="The total amount of funds in the account")
    public Double getCurrent() {
        return this.current;
    }

    public void setCurrent(Double current) {
        this.current = current;
    }

    public WalletBalance available(Double available) {
        this.available = available;
        return this;
    }

    @ApiModelProperty(required=true, value="The total amount of funds in the account after subtracting pending debit transaction amounts")
    public Double getAvailable() {
        return this.available;
    }

    public void setAvailable(Double available) {
        this.available = available;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletBalance walletBalance = (WalletBalance)o;
        return Objects.equals(this.isoCurrencyCode, walletBalance.isoCurrencyCode) && Objects.equals(this.current, walletBalance.current) && Objects.equals(this.available, walletBalance.available);
    }

    public int hashCode() {
        return Objects.hash(this.isoCurrencyCode, this.current, this.available);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletBalance {\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    available: ").append(this.toIndentedString(this.available)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

