/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WalletISOCurrencyCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WalletCreateRequest defines the request schema for `/wallet/create`")
public class WalletCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private WalletISOCurrencyCode isoCurrencyCode;

    public WalletCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public WalletCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WalletCreateRequest isoCurrencyCode(WalletISOCurrencyCode isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletISOCurrencyCode getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(WalletISOCurrencyCode isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletCreateRequest walletCreateRequest = (WalletCreateRequest)o;
        return Objects.equals(this.clientId, walletCreateRequest.clientId) && Objects.equals(this.secret, walletCreateRequest.secret) && Objects.equals((Object)this.isoCurrencyCode, (Object)walletCreateRequest.isoCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.isoCurrencyCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString((Object)this.isoCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

