/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Wallet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WalletListResponse defines the response schema for `/wallet/list`")
public class WalletListResponse {
    public static final String SERIALIZED_NAME_WALLETS = "wallets";
    @SerializedName(value="wallets")
    private List<Wallet> wallets = new ArrayList<Wallet>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WalletListResponse wallets(List<Wallet> wallets) {
        this.wallets = wallets;
        return this;
    }

    public WalletListResponse addWalletsItem(Wallet walletsItem) {
        this.wallets.add(walletsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of e-wallets")
    public List<Wallet> getWallets() {
        return this.wallets;
    }

    public void setWallets(List<Wallet> wallets) {
        this.wallets = wallets;
    }

    public WalletListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cursor used for fetching e-wallets created before the latest e-wallet provided in this response")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public WalletListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletListResponse walletListResponse = (WalletListResponse)o;
        return Objects.equals(this.wallets, walletListResponse.wallets) && Objects.equals(this.nextCursor, walletListResponse.nextCursor) && Objects.equals(this.requestId, walletListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.wallets, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletListResponse {\n");
        sb.append("    wallets: ").append(this.toIndentedString(this.wallets)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

