/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationAddress;
import com.plaid.client.model.WalletTransactionCounterpartyNumbers;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the e-wallet transaction's counterparty")
public class WalletTransactionCounterparty {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NUMBERS = "numbers";
    @SerializedName(value="numbers")
    private WalletTransactionCounterpartyNumbers numbers;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private PaymentInitiationAddress address;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "date_of_birth";
    @SerializedName(value="date_of_birth")
    private LocalDate dateOfBirth;

    public WalletTransactionCounterparty name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the counterparty")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WalletTransactionCounterparty numbers(WalletTransactionCounterpartyNumbers numbers) {
        this.numbers = numbers;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletTransactionCounterpartyNumbers getNumbers() {
        return this.numbers;
    }

    public void setNumbers(WalletTransactionCounterpartyNumbers numbers) {
        this.numbers = numbers;
    }

    public WalletTransactionCounterparty address(PaymentInitiationAddress address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationAddress getAddress() {
        return this.address;
    }

    public void setAddress(PaymentInitiationAddress address) {
        this.address = address;
    }

    public WalletTransactionCounterparty dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's birthdate, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) (YYYY-MM-DD) format.")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletTransactionCounterparty walletTransactionCounterparty = (WalletTransactionCounterparty)o;
        return Objects.equals(this.name, walletTransactionCounterparty.name) && Objects.equals(this.numbers, walletTransactionCounterparty.numbers) && Objects.equals(this.address, walletTransactionCounterparty.address) && Objects.equals(this.dateOfBirth, walletTransactionCounterparty.dateOfBirth);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.numbers, this.address, this.dateOfBirth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletTransactionCounterparty {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numbers: ").append(this.toIndentedString(this.numbers)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

