/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.WalletPaymentScheme;
import com.plaid.client.model.WalletTransactionAmount;
import com.plaid.client.model.WalletTransactionCounterparty;
import com.plaid.client.model.WalletTransactionFailureReason;
import com.plaid.client.model.WalletTransactionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WalletTransactionGetResponse defines the response schema for `/wallet/transaction/get`")
public class WalletTransactionGetResponse {
    public static final String SERIALIZED_NAME_TRANSACTION_ID = "transaction_id";
    @SerializedName(value="transaction_id")
    private String transactionId;
    public static final String SERIALIZED_NAME_WALLET_ID = "wallet_id";
    @SerializedName(value="wallet_id")
    private String walletId;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static final String SERIALIZED_NAME_SCHEME = "scheme";
    @SerializedName(value="scheme")
    private WalletPaymentScheme scheme;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private WalletTransactionAmount amount;
    public static final String SERIALIZED_NAME_COUNTERPARTY = "counterparty";
    @SerializedName(value="counterparty")
    private WalletTransactionCounterparty counterparty;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WalletTransactionStatus status;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_LAST_STATUS_UPDATE = "last_status_update";
    @SerializedName(value="last_status_update")
    private OffsetDateTime lastStatusUpdate;
    public static final String SERIALIZED_NAME_PAYMENT_ID = "payment_id";
    @SerializedName(value="payment_id")
    private String paymentId;
    public static final String SERIALIZED_NAME_FAILURE_REASON = "failure_reason";
    @SerializedName(value="failure_reason")
    private WalletTransactionFailureReason failureReason;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WalletTransactionGetResponse transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique ID identifying the transaction")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public WalletTransactionGetResponse walletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    @ApiModelProperty(required=true, value="The EMI (E-Money Institution) wallet that this payment is associated with, if any. This wallet is used as an intermediary account to enable Plaid to reconcile the settlement of funds for Payment Initiation requests.")
    public String getWalletId() {
        return this.walletId;
    }

    public void setWalletId(String walletId) {
        this.walletId = walletId;
    }

    public WalletTransactionGetResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference for the transaction")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public WalletTransactionGetResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the transaction. The supported transaction types that are returned are: `BANK_TRANSFER:` a transaction which credits an e-wallet through an external bank transfer.  `PAYOUT:` a transaction which debits an e-wallet by disbursing funds to a counterparty.  `PIS_PAY_IN:` a payment which credits an e-wallet through Plaid's Payment Initiation Services (PIS) APIs. For more information see the [Payment Initiation endpoints](https://plaid.com/docs/api/products/payment-initiation/).  `REFUND:` a transaction which debits an e-wallet by refunding a previously initiated payment made through Plaid's [PIS APIs](https://plaid.com/docs/api/products/payment-initiation/).  `FUNDS_SWEEP`: an automated transaction which debits funds from an e-wallet to a designated client-owned account.  `RETURN`: an automated transaction where a debit transaction was reversed and money moved back to originating account.  `RECALL`: a transaction where the sending bank has requested the return of funds due to a fraud claim, technical error, or other issue associated with the payment.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public WalletTransactionGetResponse scheme(WalletPaymentScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WalletPaymentScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(WalletPaymentScheme scheme) {
        this.scheme = scheme;
    }

    public WalletTransactionGetResponse amount(WalletTransactionAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletTransactionAmount getAmount() {
        return this.amount;
    }

    public void setAmount(WalletTransactionAmount amount) {
        this.amount = amount;
    }

    public WalletTransactionGetResponse counterparty(WalletTransactionCounterparty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletTransactionCounterparty getCounterparty() {
        return this.counterparty;
    }

    public void setCounterparty(WalletTransactionCounterparty counterparty) {
        this.counterparty = counterparty;
    }

    public WalletTransactionGetResponse status(WalletTransactionStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WalletTransactionStatus getStatus() {
        return this.status;
    }

    public void setStatus(WalletTransactionStatus status) {
        this.status = status;
    }

    public WalletTransactionGetResponse createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Timestamp when the transaction was created, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public WalletTransactionGetResponse lastStatusUpdate(OffsetDateTime lastStatusUpdate) {
        this.lastStatusUpdate = lastStatusUpdate;
        return this;
    }

    @ApiModelProperty(required=true, value="The date and time of the last time the `status` was updated, in IS0 8601 format")
    public OffsetDateTime getLastStatusUpdate() {
        return this.lastStatusUpdate;
    }

    public void setLastStatusUpdate(OffsetDateTime lastStatusUpdate) {
        this.lastStatusUpdate = lastStatusUpdate;
    }

    public WalletTransactionGetResponse paymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The payment id that this transaction is associated with, if any. This is present only for transaction types `PIS_PAY_IN` and `REFUND`.")
    public String getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public WalletTransactionGetResponse failureReason(WalletTransactionFailureReason failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WalletTransactionFailureReason getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(WalletTransactionFailureReason failureReason) {
        this.failureReason = failureReason;
    }

    public WalletTransactionGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletTransactionGetResponse walletTransactionGetResponse = (WalletTransactionGetResponse)o;
        return Objects.equals(this.transactionId, walletTransactionGetResponse.transactionId) && Objects.equals(this.walletId, walletTransactionGetResponse.walletId) && Objects.equals(this.reference, walletTransactionGetResponse.reference) && Objects.equals((Object)this.type, (Object)walletTransactionGetResponse.type) && Objects.equals((Object)this.scheme, (Object)walletTransactionGetResponse.scheme) && Objects.equals(this.amount, walletTransactionGetResponse.amount) && Objects.equals(this.counterparty, walletTransactionGetResponse.counterparty) && Objects.equals((Object)this.status, (Object)walletTransactionGetResponse.status) && Objects.equals(this.createdAt, walletTransactionGetResponse.createdAt) && Objects.equals(this.lastStatusUpdate, walletTransactionGetResponse.lastStatusUpdate) && Objects.equals(this.paymentId, walletTransactionGetResponse.paymentId) && Objects.equals((Object)this.failureReason, (Object)walletTransactionGetResponse.failureReason) && Objects.equals(this.requestId, walletTransactionGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.walletId, this.reference, this.type, this.scheme, this.amount, this.counterparty, this.status, this.createdAt, this.lastStatusUpdate, this.paymentId, this.failureReason, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletTransactionGetResponse {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    walletId: ").append(this.toIndentedString(this.walletId)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString((Object)this.scheme)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    lastStatusUpdate: ").append(this.toIndentedString(this.lastStatusUpdate)).append("\n");
        sb.append("    paymentId: ").append(this.toIndentedString(this.paymentId)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString((Object)this.failureReason)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BANK_TRANSFER("BANK_TRANSFER"),
        PAYOUT("PAYOUT"),
        PIS_PAY_IN("PIS_PAY_IN"),
        REFUND("REFUND"),
        FUNDS_SWEEP("FUNDS_SWEEP"),
        RETURN("RETURN"),
        RECALL("RECALL");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

