/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Additional wallet transaction options")
public class WalletTransactionListRequestOptions {
    public static final String SERIALIZED_NAME_START_TIME = "start_time";
    @SerializedName(value="start_time")
    private OffsetDateTime startTime;
    public static final String SERIALIZED_NAME_END_TIME = "end_time";
    @SerializedName(value="end_time")
    private OffsetDateTime endTime;

    public WalletTransactionListRequestOptions startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDThh:mm:ssZ) for filtering transactions, inclusive of the provided date.")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public WalletTransactionListRequestOptions endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DDThh:mm:ssZ) for filtering transactions, inclusive of the provided date.")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletTransactionListRequestOptions walletTransactionListRequestOptions = (WalletTransactionListRequestOptions)o;
        return Objects.equals(this.startTime, walletTransactionListRequestOptions.startTime) && Objects.equals(this.endTime, walletTransactionListRequestOptions.endTime);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletTransactionListRequestOptions {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

