/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WalletTransaction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WalletTransactionListResponse defines the response schema for `/wallet/transaction/list`")
public class WalletTransactionListResponse {
    public static final String SERIALIZED_NAME_TRANSACTIONS = "transactions";
    @SerializedName(value="transactions")
    private List<WalletTransaction> transactions = new ArrayList<WalletTransaction>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public WalletTransactionListResponse transactions(List<WalletTransaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public WalletTransactionListResponse addTransactionsItem(WalletTransaction transactionsItem) {
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of transactions of an e-wallet, associated with the given `wallet_id`")
    public List<WalletTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<WalletTransaction> transactions) {
        this.transactions = transactions;
    }

    public WalletTransactionListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cursor used for fetching transactions created before the latest transaction provided in this response")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public WalletTransactionListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletTransactionListResponse walletTransactionListResponse = (WalletTransactionListResponse)o;
        return Objects.equals(this.transactions, walletTransactionListResponse.transactions) && Objects.equals(this.nextCursor, walletTransactionListResponse.nextCursor) && Objects.equals(this.requestId, walletTransactionListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.transactions, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletTransactionListResponse {\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

